// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.AppPlatform
{
    /// <summary>
    /// A class representing a collection of <see cref="AppPlatformBuildResultResource"/> and their operations.
    /// Each <see cref="AppPlatformBuildResultResource"/> in the collection will belong to the same instance of <see cref="AppPlatformBuildResource"/>.
    /// To get an <see cref="AppPlatformBuildResultCollection"/> instance call the GetAppPlatformBuildResults method from an instance of <see cref="AppPlatformBuildResource"/>.
    /// </summary>
    public partial class AppPlatformBuildResultCollection : ArmCollection, IEnumerable<AppPlatformBuildResultResource>, IAsyncEnumerable<AppPlatformBuildResultResource>
    {
        private readonly ClientDiagnostics _appPlatformBuildResultBuildServiceClientDiagnostics;
        private readonly BuildServiceRestOperations _appPlatformBuildResultBuildServiceRestClient;

        /// <summary> Initializes a new instance of the <see cref="AppPlatformBuildResultCollection"/> class for mocking. </summary>
        protected AppPlatformBuildResultCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AppPlatformBuildResultCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AppPlatformBuildResultCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _appPlatformBuildResultBuildServiceClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.AppPlatform", AppPlatformBuildResultResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AppPlatformBuildResultResource.ResourceType, out string appPlatformBuildResultBuildServiceApiVersion);
            _appPlatformBuildResultBuildServiceRestClient = new BuildServiceRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, appPlatformBuildResultBuildServiceApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != AppPlatformBuildResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, AppPlatformBuildResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a KPack build result.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BuildService_GetBuildResult</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformBuildResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="buildResultName"> The name of the build result resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="buildResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="buildResultName"/> is null. </exception>
        public virtual async Task<Response<AppPlatformBuildResultResource>> GetAsync(string buildResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(buildResultName, nameof(buildResultName));

            using var scope = _appPlatformBuildResultBuildServiceClientDiagnostics.CreateScope("AppPlatformBuildResultCollection.Get");
            scope.Start();
            try
            {
                var response = await _appPlatformBuildResultBuildServiceRestClient.GetBuildResultAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, buildResultName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppPlatformBuildResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a KPack build result.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BuildService_GetBuildResult</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformBuildResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="buildResultName"> The name of the build result resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="buildResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="buildResultName"/> is null. </exception>
        public virtual Response<AppPlatformBuildResultResource> Get(string buildResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(buildResultName, nameof(buildResultName));

            using var scope = _appPlatformBuildResultBuildServiceClientDiagnostics.CreateScope("AppPlatformBuildResultCollection.Get");
            scope.Start();
            try
            {
                var response = _appPlatformBuildResultBuildServiceRestClient.GetBuildResult(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, buildResultName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppPlatformBuildResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List KPack build results.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BuildService_ListBuildResults</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformBuildResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AppPlatformBuildResultResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AppPlatformBuildResultResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _appPlatformBuildResultBuildServiceRestClient.CreateListBuildResultsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _appPlatformBuildResultBuildServiceRestClient.CreateListBuildResultsNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AppPlatformBuildResultResource(Client, AppPlatformBuildResultData.DeserializeAppPlatformBuildResultData(e)), _appPlatformBuildResultBuildServiceClientDiagnostics, Pipeline, "AppPlatformBuildResultCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List KPack build results.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BuildService_ListBuildResults</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformBuildResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AppPlatformBuildResultResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AppPlatformBuildResultResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _appPlatformBuildResultBuildServiceRestClient.CreateListBuildResultsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _appPlatformBuildResultBuildServiceRestClient.CreateListBuildResultsNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AppPlatformBuildResultResource(Client, AppPlatformBuildResultData.DeserializeAppPlatformBuildResultData(e)), _appPlatformBuildResultBuildServiceClientDiagnostics, Pipeline, "AppPlatformBuildResultCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BuildService_GetBuildResult</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformBuildResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="buildResultName"> The name of the build result resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="buildResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="buildResultName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string buildResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(buildResultName, nameof(buildResultName));

            using var scope = _appPlatformBuildResultBuildServiceClientDiagnostics.CreateScope("AppPlatformBuildResultCollection.Exists");
            scope.Start();
            try
            {
                var response = await _appPlatformBuildResultBuildServiceRestClient.GetBuildResultAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, buildResultName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BuildService_GetBuildResult</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformBuildResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="buildResultName"> The name of the build result resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="buildResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="buildResultName"/> is null. </exception>
        public virtual Response<bool> Exists(string buildResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(buildResultName, nameof(buildResultName));

            using var scope = _appPlatformBuildResultBuildServiceClientDiagnostics.CreateScope("AppPlatformBuildResultCollection.Exists");
            scope.Start();
            try
            {
                var response = _appPlatformBuildResultBuildServiceRestClient.GetBuildResult(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, buildResultName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BuildService_GetBuildResult</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformBuildResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="buildResultName"> The name of the build result resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="buildResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="buildResultName"/> is null. </exception>
        public virtual async Task<NullableResponse<AppPlatformBuildResultResource>> GetIfExistsAsync(string buildResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(buildResultName, nameof(buildResultName));

            using var scope = _appPlatformBuildResultBuildServiceClientDiagnostics.CreateScope("AppPlatformBuildResultCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _appPlatformBuildResultBuildServiceRestClient.GetBuildResultAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, buildResultName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AppPlatformBuildResultResource>(response.GetRawResponse());
                return Response.FromValue(new AppPlatformBuildResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BuildService_GetBuildResult</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformBuildResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="buildResultName"> The name of the build result resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="buildResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="buildResultName"/> is null. </exception>
        public virtual NullableResponse<AppPlatformBuildResultResource> GetIfExists(string buildResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(buildResultName, nameof(buildResultName));

            using var scope = _appPlatformBuildResultBuildServiceClientDiagnostics.CreateScope("AppPlatformBuildResultCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _appPlatformBuildResultBuildServiceRestClient.GetBuildResult(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, buildResultName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AppPlatformBuildResultResource>(response.GetRawResponse());
                return Response.FromValue(new AppPlatformBuildResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AppPlatformBuildResultResource> IEnumerable<AppPlatformBuildResultResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AppPlatformBuildResultResource> IAsyncEnumerable<AppPlatformBuildResultResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
