// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.AppPlatform.Samples
{
    public partial class Sample_AppPlatformGatewayCustomDomainResource
    {
        // GatewayCustomDomains_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GatewayCustomDomainsGet()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/GatewayCustomDomains_Get.json
            // this example is just showing the usage of "GatewayCustomDomains_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformGatewayCustomDomainResource created on azure
            // for more information of creating AppPlatformGatewayCustomDomainResource, please refer to the document of AppPlatformGatewayCustomDomainResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string gatewayName = "default";
            string domainName = "myDomainName";
            ResourceIdentifier appPlatformGatewayCustomDomainResourceId = AppPlatformGatewayCustomDomainResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, gatewayName, domainName);
            AppPlatformGatewayCustomDomainResource appPlatformGatewayCustomDomain = client.GetAppPlatformGatewayCustomDomainResource(appPlatformGatewayCustomDomainResourceId);

            // invoke the operation
            AppPlatformGatewayCustomDomainResource result = await appPlatformGatewayCustomDomain.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformGatewayCustomDomainData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GatewayCustomDomains_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_GatewayCustomDomainsCreateOrUpdate()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/GatewayCustomDomains_CreateOrUpdate.json
            // this example is just showing the usage of "GatewayCustomDomains_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformGatewayCustomDomainResource created on azure
            // for more information of creating AppPlatformGatewayCustomDomainResource, please refer to the document of AppPlatformGatewayCustomDomainResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string gatewayName = "default";
            string domainName = "myDomainName";
            ResourceIdentifier appPlatformGatewayCustomDomainResourceId = AppPlatformGatewayCustomDomainResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, gatewayName, domainName);
            AppPlatformGatewayCustomDomainResource appPlatformGatewayCustomDomain = client.GetAppPlatformGatewayCustomDomainResource(appPlatformGatewayCustomDomainResourceId);

            // invoke the operation
            AppPlatformGatewayCustomDomainData data = new AppPlatformGatewayCustomDomainData()
            {
                GatewayCustomDomainThumbprint = "*",
            };
            ArmOperation<AppPlatformGatewayCustomDomainResource> lro = await appPlatformGatewayCustomDomain.UpdateAsync(WaitUntil.Completed, data);
            AppPlatformGatewayCustomDomainResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformGatewayCustomDomainData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GatewayCustomDomains_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_GatewayCustomDomainsDelete()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/GatewayCustomDomains_Delete.json
            // this example is just showing the usage of "GatewayCustomDomains_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformGatewayCustomDomainResource created on azure
            // for more information of creating AppPlatformGatewayCustomDomainResource, please refer to the document of AppPlatformGatewayCustomDomainResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string gatewayName = "default";
            string domainName = "myDomainName";
            ResourceIdentifier appPlatformGatewayCustomDomainResourceId = AppPlatformGatewayCustomDomainResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, gatewayName, domainName);
            AppPlatformGatewayCustomDomainResource appPlatformGatewayCustomDomain = client.GetAppPlatformGatewayCustomDomainResource(appPlatformGatewayCustomDomainResourceId);

            // invoke the operation
            await appPlatformGatewayCustomDomain.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
