// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.AppPlatform.Models;

namespace Azure.ResourceManager.AppPlatform.Samples
{
    public partial class Sample_AppPlatformDeploymentCollection
    {
        // Deployments_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_DeploymentsGet()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Deployments_Get.json
            // this example is just showing the usage of "Deployments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformAppResource created on azure
            // for more information of creating AppPlatformAppResource, please refer to the document of AppPlatformAppResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string appName = "myapp";
            ResourceIdentifier appPlatformAppResourceId = AppPlatformAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, appName);
            AppPlatformAppResource appPlatformApp = client.GetAppPlatformAppResource(appPlatformAppResourceId);

            // get the collection of this AppPlatformDeploymentResource
            AppPlatformDeploymentCollection collection = appPlatformApp.GetAppPlatformDeployments();

            // invoke the operation
            string deploymentName = "mydeployment";
            AppPlatformDeploymentResource result = await collection.GetAsync(deploymentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformDeploymentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deployments_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_DeploymentsGet()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Deployments_Get.json
            // this example is just showing the usage of "Deployments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformAppResource created on azure
            // for more information of creating AppPlatformAppResource, please refer to the document of AppPlatformAppResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string appName = "myapp";
            ResourceIdentifier appPlatformAppResourceId = AppPlatformAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, appName);
            AppPlatformAppResource appPlatformApp = client.GetAppPlatformAppResource(appPlatformAppResourceId);

            // get the collection of this AppPlatformDeploymentResource
            AppPlatformDeploymentCollection collection = appPlatformApp.GetAppPlatformDeployments();

            // invoke the operation
            string deploymentName = "mydeployment";
            bool result = await collection.ExistsAsync(deploymentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Deployments_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_DeploymentsGet()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Deployments_Get.json
            // this example is just showing the usage of "Deployments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformAppResource created on azure
            // for more information of creating AppPlatformAppResource, please refer to the document of AppPlatformAppResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string appName = "myapp";
            ResourceIdentifier appPlatformAppResourceId = AppPlatformAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, appName);
            AppPlatformAppResource appPlatformApp = client.GetAppPlatformAppResource(appPlatformAppResourceId);

            // get the collection of this AppPlatformDeploymentResource
            AppPlatformDeploymentCollection collection = appPlatformApp.GetAppPlatformDeployments();

            // invoke the operation
            string deploymentName = "mydeployment";
            NullableResponse<AppPlatformDeploymentResource> response = await collection.GetIfExistsAsync(deploymentName);
            AppPlatformDeploymentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AppPlatformDeploymentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Deployments_Get_CustomContainer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_DeploymentsGetCustomContainer()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Deployments_Get_CustomContainer.json
            // this example is just showing the usage of "Deployments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformAppResource created on azure
            // for more information of creating AppPlatformAppResource, please refer to the document of AppPlatformAppResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string appName = "myapp";
            ResourceIdentifier appPlatformAppResourceId = AppPlatformAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, appName);
            AppPlatformAppResource appPlatformApp = client.GetAppPlatformAppResource(appPlatformAppResourceId);

            // get the collection of this AppPlatformDeploymentResource
            AppPlatformDeploymentCollection collection = appPlatformApp.GetAppPlatformDeployments();

            // invoke the operation
            string deploymentName = "mydeployment";
            AppPlatformDeploymentResource result = await collection.GetAsync(deploymentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformDeploymentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deployments_Get_CustomContainer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_DeploymentsGetCustomContainer()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Deployments_Get_CustomContainer.json
            // this example is just showing the usage of "Deployments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformAppResource created on azure
            // for more information of creating AppPlatformAppResource, please refer to the document of AppPlatformAppResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string appName = "myapp";
            ResourceIdentifier appPlatformAppResourceId = AppPlatformAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, appName);
            AppPlatformAppResource appPlatformApp = client.GetAppPlatformAppResource(appPlatformAppResourceId);

            // get the collection of this AppPlatformDeploymentResource
            AppPlatformDeploymentCollection collection = appPlatformApp.GetAppPlatformDeployments();

            // invoke the operation
            string deploymentName = "mydeployment";
            bool result = await collection.ExistsAsync(deploymentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Deployments_Get_CustomContainer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_DeploymentsGetCustomContainer()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Deployments_Get_CustomContainer.json
            // this example is just showing the usage of "Deployments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformAppResource created on azure
            // for more information of creating AppPlatformAppResource, please refer to the document of AppPlatformAppResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string appName = "myapp";
            ResourceIdentifier appPlatformAppResourceId = AppPlatformAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, appName);
            AppPlatformAppResource appPlatformApp = client.GetAppPlatformAppResource(appPlatformAppResourceId);

            // get the collection of this AppPlatformDeploymentResource
            AppPlatformDeploymentCollection collection = appPlatformApp.GetAppPlatformDeployments();

            // invoke the operation
            string deploymentName = "mydeployment";
            NullableResponse<AppPlatformDeploymentResource> response = await collection.GetIfExistsAsync(deploymentName);
            AppPlatformDeploymentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AppPlatformDeploymentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Deployments_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_DeploymentsCreateOrUpdate()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Deployments_CreateOrUpdate.json
            // this example is just showing the usage of "Deployments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformAppResource created on azure
            // for more information of creating AppPlatformAppResource, please refer to the document of AppPlatformAppResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string appName = "myapp";
            ResourceIdentifier appPlatformAppResourceId = AppPlatformAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, appName);
            AppPlatformAppResource appPlatformApp = client.GetAppPlatformAppResource(appPlatformAppResourceId);

            // get the collection of this AppPlatformDeploymentResource
            AppPlatformDeploymentCollection collection = appPlatformApp.GetAppPlatformDeployments();

            // invoke the operation
            string deploymentName = "mydeployment";
            AppPlatformDeploymentData data = new AppPlatformDeploymentData()
            {
                Properties = new AppPlatformDeploymentProperties()
                {
                    Source = new SourceUploadedUserSourceInfo()
                    {
                        ArtifactSelector = "sub-module-1",
                        RelativePath = "resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc",
                        Version = "1.0",
                    },
                    DeploymentSettings = new AppPlatformDeploymentSettings()
                    {
                        ResourceRequests = new AppPlatformDeploymentResourceRequirements()
                        {
                            Cpu = "1000m",
                            Memory = "3Gi",
                        },
                        EnvironmentVariables =
{
["env"] = "test",
},
                        AddonConfigs =
{
["ApplicationConfigurationService"] = new Dictionary<string, BinaryData>()
{
["patterns"] = BinaryData.FromObjectAsJson(new object[] { "mypattern" }),
},
},
                        LivenessProbe = new AppInstanceProbe(false)
                        {
                            ProbeAction = new AppInstanceHttpGetAction()
                            {
                                Path = "/health",
                                Scheme = AppInstanceHttpSchemeType.Http,
                            },
                            InitialDelayInSeconds = 30,
                            PeriodInSeconds = 10,
                            FailureThreshold = 3,
                        },
                        ReadinessProbe = new AppInstanceProbe(false)
                        {
                            ProbeAction = new AppInstanceHttpGetAction()
                            {
                                Path = "/health",
                                Scheme = AppInstanceHttpSchemeType.Http,
                            },
                            InitialDelayInSeconds = 30,
                            PeriodInSeconds = 10,
                            FailureThreshold = 3,
                        },
                        StartupProbe = null,
                        TerminationGracePeriodInSeconds = 30,
                    },
                },
                Sku = new AppPlatformSku()
                {
                    Name = "S0",
                    Tier = "Standard",
                    Capacity = 1,
                },
            };
            ArmOperation<AppPlatformDeploymentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, deploymentName, data);
            AppPlatformDeploymentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformDeploymentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deployments_CreateOrUpdate_CustomContainer
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_DeploymentsCreateOrUpdateCustomContainer()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Deployments_CreateOrUpdate_CustomContainer.json
            // this example is just showing the usage of "Deployments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformAppResource created on azure
            // for more information of creating AppPlatformAppResource, please refer to the document of AppPlatformAppResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string appName = "myapp";
            ResourceIdentifier appPlatformAppResourceId = AppPlatformAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, appName);
            AppPlatformAppResource appPlatformApp = client.GetAppPlatformAppResource(appPlatformAppResourceId);

            // get the collection of this AppPlatformDeploymentResource
            AppPlatformDeploymentCollection collection = appPlatformApp.GetAppPlatformDeployments();

            // invoke the operation
            string deploymentName = "mydeployment";
            AppPlatformDeploymentData data = new AppPlatformDeploymentData()
            {
                Properties = new AppPlatformDeploymentProperties()
                {
                    Source = new AppPlatformCustomContainerUserSourceInfo()
                    {
                        CustomContainer = new AppPlatformCustomContainer()
                        {
                            Server = "myacr.azurecr.io",
                            ContainerImage = "myContainerImage:v1",
                            Command =
{
"/bin/sh"
},
                            Args =
{
"-c","while true; do echo hello; sleep 10;done"
},
                            ImageRegistryCredential = new AppPlatformImageRegistryCredential()
                            {
                                Username = "myUsername",
                                Password = "myPassword",
                            },
                            LanguageFramework = "springboot",
                        },
                    },
                    DeploymentSettings = new AppPlatformDeploymentSettings()
                    {
                        ResourceRequests = new AppPlatformDeploymentResourceRequirements()
                        {
                            Cpu = "1000m",
                            Memory = "3Gi",
                        },
                        EnvironmentVariables =
{
["env"] = "test",
},
                        LivenessProbe = new AppInstanceProbe(false)
                        {
                            ProbeAction = new AppInstanceHttpGetAction()
                            {
                                Path = "/health",
                                Scheme = AppInstanceHttpSchemeType.Http,
                            },
                            InitialDelayInSeconds = 30,
                            PeriodInSeconds = 10,
                            FailureThreshold = 3,
                        },
                        ReadinessProbe = new AppInstanceProbe(false)
                        {
                            ProbeAction = new AppInstanceHttpGetAction()
                            {
                                Path = "/health",
                                Scheme = AppInstanceHttpSchemeType.Http,
                            },
                            InitialDelayInSeconds = 30,
                            PeriodInSeconds = 10,
                            FailureThreshold = 3,
                        },
                        StartupProbe = null,
                        TerminationGracePeriodInSeconds = 30,
                    },
                },
            };
            ArmOperation<AppPlatformDeploymentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, deploymentName, data);
            AppPlatformDeploymentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformDeploymentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deployments_List
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_DeploymentsList()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Deployments_List.json
            // this example is just showing the usage of "Deployments_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformAppResource created on azure
            // for more information of creating AppPlatformAppResource, please refer to the document of AppPlatformAppResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string appName = "myapp";
            ResourceIdentifier appPlatformAppResourceId = AppPlatformAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, appName);
            AppPlatformAppResource appPlatformApp = client.GetAppPlatformAppResource(appPlatformAppResourceId);

            // get the collection of this AppPlatformDeploymentResource
            AppPlatformDeploymentCollection collection = appPlatformApp.GetAppPlatformDeployments();

            // invoke the operation and iterate over the result
            await foreach (AppPlatformDeploymentResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AppPlatformDeploymentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
