// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.AppPlatform.Models;

namespace Azure.ResourceManager.AppPlatform.Samples
{
    public partial class Sample_AppPlatformBuildResultResource
    {
        // BuildService_GetBuildResult
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_BuildServiceGetBuildResult()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/BuildService_GetBuildResult.json
            // this example is just showing the usage of "BuildService_GetBuildResult" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformBuildResultResource created on azure
            // for more information of creating AppPlatformBuildResultResource, please refer to the document of AppPlatformBuildResultResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string buildServiceName = "default";
            string buildName = "mybuild";
            string buildResultName = "123";
            ResourceIdentifier appPlatformBuildResultResourceId = AppPlatformBuildResultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, buildServiceName, buildName, buildResultName);
            AppPlatformBuildResultResource appPlatformBuildResult = client.GetAppPlatformBuildResultResource(appPlatformBuildResultResourceId);

            // invoke the operation
            AppPlatformBuildResultResource result = await appPlatformBuildResult.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformBuildResultData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // BuildService_GetBuildResultLog
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetBuildResultLog_BuildServiceGetBuildResultLog()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/BuildService_GetBuildResultLog.json
            // this example is just showing the usage of "BuildService_GetBuildResultLog" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformBuildResultResource created on azure
            // for more information of creating AppPlatformBuildResultResource, please refer to the document of AppPlatformBuildResultResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string buildServiceName = "default";
            string buildName = "mybuild";
            string buildResultName = "123";
            ResourceIdentifier appPlatformBuildResultResourceId = AppPlatformBuildResultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, buildServiceName, buildName, buildResultName);
            AppPlatformBuildResultResource appPlatformBuildResult = client.GetAppPlatformBuildResultResource(appPlatformBuildResultResourceId);

            // invoke the operation
            AppPlatformBuildResultLog result = await appPlatformBuildResult.GetBuildResultLogAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
