// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.AppPlatform.Samples
{
    public partial class Sample_AppPlatformApiPortalCustomDomainCollection
    {
        // ApiPortalCustomDomains_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiPortalCustomDomainsGet()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/ApiPortalCustomDomains_Get.json
            // this example is just showing the usage of "ApiPortalCustomDomains_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformApiPortalResource created on azure
            // for more information of creating AppPlatformApiPortalResource, please refer to the document of AppPlatformApiPortalResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string apiPortalName = "default";
            ResourceIdentifier appPlatformApiPortalResourceId = AppPlatformApiPortalResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, apiPortalName);
            AppPlatformApiPortalResource appPlatformApiPortal = client.GetAppPlatformApiPortalResource(appPlatformApiPortalResourceId);

            // get the collection of this AppPlatformApiPortalCustomDomainResource
            AppPlatformApiPortalCustomDomainCollection collection = appPlatformApiPortal.GetAppPlatformApiPortalCustomDomains();

            // invoke the operation
            string domainName = "myDomainName";
            AppPlatformApiPortalCustomDomainResource result = await collection.GetAsync(domainName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformApiPortalCustomDomainData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiPortalCustomDomains_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ApiPortalCustomDomainsGet()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/ApiPortalCustomDomains_Get.json
            // this example is just showing the usage of "ApiPortalCustomDomains_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformApiPortalResource created on azure
            // for more information of creating AppPlatformApiPortalResource, please refer to the document of AppPlatformApiPortalResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string apiPortalName = "default";
            ResourceIdentifier appPlatformApiPortalResourceId = AppPlatformApiPortalResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, apiPortalName);
            AppPlatformApiPortalResource appPlatformApiPortal = client.GetAppPlatformApiPortalResource(appPlatformApiPortalResourceId);

            // get the collection of this AppPlatformApiPortalCustomDomainResource
            AppPlatformApiPortalCustomDomainCollection collection = appPlatformApiPortal.GetAppPlatformApiPortalCustomDomains();

            // invoke the operation
            string domainName = "myDomainName";
            bool result = await collection.ExistsAsync(domainName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiPortalCustomDomains_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ApiPortalCustomDomainsGet()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/ApiPortalCustomDomains_Get.json
            // this example is just showing the usage of "ApiPortalCustomDomains_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformApiPortalResource created on azure
            // for more information of creating AppPlatformApiPortalResource, please refer to the document of AppPlatformApiPortalResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string apiPortalName = "default";
            ResourceIdentifier appPlatformApiPortalResourceId = AppPlatformApiPortalResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, apiPortalName);
            AppPlatformApiPortalResource appPlatformApiPortal = client.GetAppPlatformApiPortalResource(appPlatformApiPortalResourceId);

            // get the collection of this AppPlatformApiPortalCustomDomainResource
            AppPlatformApiPortalCustomDomainCollection collection = appPlatformApiPortal.GetAppPlatformApiPortalCustomDomains();

            // invoke the operation
            string domainName = "myDomainName";
            NullableResponse<AppPlatformApiPortalCustomDomainResource> response = await collection.GetIfExistsAsync(domainName);
            AppPlatformApiPortalCustomDomainResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AppPlatformApiPortalCustomDomainData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // ApiPortalCustomDomains_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_ApiPortalCustomDomainsCreateOrUpdate()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/ApiPortalCustomDomains_CreateOrUpdate.json
            // this example is just showing the usage of "ApiPortalCustomDomains_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformApiPortalResource created on azure
            // for more information of creating AppPlatformApiPortalResource, please refer to the document of AppPlatformApiPortalResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string apiPortalName = "default";
            ResourceIdentifier appPlatformApiPortalResourceId = AppPlatformApiPortalResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, apiPortalName);
            AppPlatformApiPortalResource appPlatformApiPortal = client.GetAppPlatformApiPortalResource(appPlatformApiPortalResourceId);

            // get the collection of this AppPlatformApiPortalCustomDomainResource
            AppPlatformApiPortalCustomDomainCollection collection = appPlatformApiPortal.GetAppPlatformApiPortalCustomDomains();

            // invoke the operation
            string domainName = "myDomainName";
            AppPlatformApiPortalCustomDomainData data = new AppPlatformApiPortalCustomDomainData()
            {
                ApiPortalCustomDomainThumbprint = "*",
            };
            ArmOperation<AppPlatformApiPortalCustomDomainResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, domainName, data);
            AppPlatformApiPortalCustomDomainResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AppPlatformApiPortalCustomDomainData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiPortalCustomDomains_List
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ApiPortalCustomDomainsList()
        {
            // Generated from example definition: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/ApiPortalCustomDomains_List.json
            // this example is just showing the usage of "ApiPortalCustomDomains_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AppPlatformApiPortalResource created on azure
            // for more information of creating AppPlatformApiPortalResource, please refer to the document of AppPlatformApiPortalResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string serviceName = "myservice";
            string apiPortalName = "default";
            ResourceIdentifier appPlatformApiPortalResourceId = AppPlatformApiPortalResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, apiPortalName);
            AppPlatformApiPortalResource appPlatformApiPortal = client.GetAppPlatformApiPortalResource(appPlatformApiPortalResourceId);

            // get the collection of this AppPlatformApiPortalCustomDomainResource
            AppPlatformApiPortalCustomDomainCollection collection = appPlatformApiPortal.GetAppPlatformApiPortalCustomDomains();

            // invoke the operation and iterate over the result
            await foreach (AppPlatformApiPortalCustomDomainResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AppPlatformApiPortalCustomDomainData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
