// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> The kind of workbook. Only valid value is shared. </summary>
    public readonly partial struct WorkbookUpdateSharedTypeKind : IEquatable<WorkbookUpdateSharedTypeKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkbookUpdateSharedTypeKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkbookUpdateSharedTypeKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SharedValue = "shared";

        /// <summary> shared. </summary>
        public static WorkbookUpdateSharedTypeKind Shared { get; } = new WorkbookUpdateSharedTypeKind(SharedValue);
        /// <summary> Determines if two <see cref="WorkbookUpdateSharedTypeKind"/> values are the same. </summary>
        public static bool operator ==(WorkbookUpdateSharedTypeKind left, WorkbookUpdateSharedTypeKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkbookUpdateSharedTypeKind"/> values are not the same. </summary>
        public static bool operator !=(WorkbookUpdateSharedTypeKind left, WorkbookUpdateSharedTypeKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkbookUpdateSharedTypeKind"/>. </summary>
        public static implicit operator WorkbookUpdateSharedTypeKind(string value) => new WorkbookUpdateSharedTypeKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkbookUpdateSharedTypeKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkbookUpdateSharedTypeKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
