// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> The WorkbookCategoryType. </summary>
    public readonly partial struct WorkbookCategoryType : IEquatable<WorkbookCategoryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkbookCategoryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkbookCategoryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WorkbookValue = "workbook";
        private const string TsgValue = "TSG";
        private const string PerformanceValue = "performance";
        private const string RetentionValue = "retention";

        /// <summary> workbook. </summary>
        public static WorkbookCategoryType Workbook { get; } = new WorkbookCategoryType(WorkbookValue);
        /// <summary> TSG. </summary>
        public static WorkbookCategoryType Tsg { get; } = new WorkbookCategoryType(TsgValue);
        /// <summary> performance. </summary>
        public static WorkbookCategoryType Performance { get; } = new WorkbookCategoryType(PerformanceValue);
        /// <summary> retention. </summary>
        public static WorkbookCategoryType Retention { get; } = new WorkbookCategoryType(RetentionValue);
        /// <summary> Determines if two <see cref="WorkbookCategoryType"/> values are the same. </summary>
        public static bool operator ==(WorkbookCategoryType left, WorkbookCategoryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkbookCategoryType"/> values are not the same. </summary>
        public static bool operator !=(WorkbookCategoryType left, WorkbookCategoryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkbookCategoryType"/>. </summary>
        public static implicit operator WorkbookCategoryType(string value) => new WorkbookCategoryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkbookCategoryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkbookCategoryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
