// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    public partial class WebTestValidationRules : IUtf8JsonSerializable, IJsonModel<WebTestValidationRules>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<WebTestValidationRules>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<WebTestValidationRules>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WebTestValidationRules>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(WebTestValidationRules)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ContentValidation))
            {
                writer.WritePropertyName("ContentValidation"u8);
                writer.WriteObjectValue(ContentValidation, options);
            }
            if (Optional.IsDefined(CheckSsl))
            {
                writer.WritePropertyName("SSLCheck"u8);
                writer.WriteBooleanValue(CheckSsl.Value);
            }
            if (Optional.IsDefined(SslCertRemainingLifetimeCheck))
            {
                writer.WritePropertyName("SSLCertRemainingLifetimeCheck"u8);
                writer.WriteNumberValue(SslCertRemainingLifetimeCheck.Value);
            }
            if (Optional.IsDefined(ExpectedHttpStatusCode))
            {
                writer.WritePropertyName("ExpectedHttpStatusCode"u8);
                writer.WriteNumberValue(ExpectedHttpStatusCode.Value);
            }
            if (Optional.IsDefined(IgnoreHttpStatusCode))
            {
                writer.WritePropertyName("IgnoreHttpStatusCode"u8);
                writer.WriteBooleanValue(IgnoreHttpStatusCode.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        WebTestValidationRules IJsonModel<WebTestValidationRules>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WebTestValidationRules>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(WebTestValidationRules)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeWebTestValidationRules(document.RootElement, options);
        }

        internal static WebTestValidationRules DeserializeWebTestValidationRules(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            WebTestContentValidation contentValidation = default;
            bool? sslCheck = default;
            int? sslCertRemainingLifetimeCheck = default;
            int? expectedHttpStatusCode = default;
            bool? ignoreHttpStatusCode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ContentValidation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    contentValidation = WebTestContentValidation.DeserializeWebTestContentValidation(property.Value, options);
                    continue;
                }
                if (property.NameEquals("SSLCheck"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sslCheck = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("SSLCertRemainingLifetimeCheck"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sslCertRemainingLifetimeCheck = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("ExpectedHttpStatusCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    expectedHttpStatusCode = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("IgnoreHttpStatusCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ignoreHttpStatusCode = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new WebTestValidationRules(
                contentValidation,
                sslCheck,
                sslCertRemainingLifetimeCheck,
                expectedHttpStatusCode,
                ignoreHttpStatusCode,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ContentValidation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ContentValidation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ContentValidation))
                {
                    builder.Append("  ContentValidation: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ContentValidation, options, 2, false, "  ContentValidation: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CheckSsl), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  SSLCheck: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CheckSsl))
                {
                    builder.Append("  SSLCheck: ");
                    var boolValue = CheckSsl.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SslCertRemainingLifetimeCheck), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  SSLCertRemainingLifetimeCheck: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SslCertRemainingLifetimeCheck))
                {
                    builder.Append("  SSLCertRemainingLifetimeCheck: ");
                    builder.AppendLine($"{SslCertRemainingLifetimeCheck.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExpectedHttpStatusCode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ExpectedHttpStatusCode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExpectedHttpStatusCode))
                {
                    builder.Append("  ExpectedHttpStatusCode: ");
                    builder.AppendLine($"{ExpectedHttpStatusCode.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IgnoreHttpStatusCode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  IgnoreHttpStatusCode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IgnoreHttpStatusCode))
                {
                    builder.Append("  IgnoreHttpStatusCode: ");
                    var boolValue = IgnoreHttpStatusCode.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<WebTestValidationRules>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WebTestValidationRules>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(WebTestValidationRules)} does not support writing '{options.Format}' format.");
            }
        }

        WebTestValidationRules IPersistableModel<WebTestValidationRules>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WebTestValidationRules>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeWebTestValidationRules(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(WebTestValidationRules)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<WebTestValidationRules>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
