// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    internal static partial class WebTestKindExtensions
    {
        public static string ToSerialString(this WebTestKind value) => value switch
        {
            WebTestKind.Ping => "ping",
            WebTestKind.MultiStep => "multistep",
            WebTestKind.Standard => "standard",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown WebTestKind value.")
        };

        public static WebTestKind ToWebTestKind(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ping")) return WebTestKind.Ping;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "multistep")) return WebTestKind.MultiStep;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "standard")) return WebTestKind.Standard;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown WebTestKind value.");
        }
    }
}
