// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> The collection of content validation properties. </summary>
    public partial class WebTestContentValidation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WebTestContentValidation"/>. </summary>
        public WebTestContentValidation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="WebTestContentValidation"/>. </summary>
        /// <param name="contentMatch"> Content to look for in the return of the WebTest.  Must not be null or empty. </param>
        /// <param name="ignoreCase"> When set, this value makes the ContentMatch validation case insensitive. </param>
        /// <param name="passIfTextFound"> When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail if there is a match. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WebTestContentValidation(string contentMatch, bool? ignoreCase, bool? passIfTextFound, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ContentMatch = contentMatch;
            IgnoreCase = ignoreCase;
            PassIfTextFound = passIfTextFound;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Content to look for in the return of the WebTest.  Must not be null or empty. </summary>
        [WirePath("ContentMatch")]
        public string ContentMatch { get; set; }
        /// <summary> When set, this value makes the ContentMatch validation case insensitive. </summary>
        [WirePath("IgnoreCase")]
        public bool? IgnoreCase { get; set; }
        /// <summary> When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail if there is a match. </summary>
        [WirePath("PassIfTextFound")]
        public bool? PassIfTextFound { get; set; }
    }
}
