// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'. </summary>
    public readonly partial struct ComponentRequestSource : IEquatable<ComponentRequestSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComponentRequestSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComponentRequestSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RestValue = "rest";

        /// <summary> rest. </summary>
        public static ComponentRequestSource Rest { get; } = new ComponentRequestSource(RestValue);
        /// <summary> Determines if two <see cref="ComponentRequestSource"/> values are the same. </summary>
        public static bool operator ==(ComponentRequestSource left, ComponentRequestSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComponentRequestSource"/> values are not the same. </summary>
        public static bool operator !=(ComponentRequestSource left, ComponentRequestSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComponentRequestSource"/>. </summary>
        public static implicit operator ComponentRequestSource(string value) => new ComponentRequestSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComponentRequestSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComponentRequestSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
