// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    public partial class ComponentPurgeContent : IUtf8JsonSerializable, IJsonModel<ComponentPurgeContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ComponentPurgeContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ComponentPurgeContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComponentPurgeContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ComponentPurgeContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("table"u8);
            writer.WriteStringValue(Table);
            writer.WritePropertyName("filters"u8);
            writer.WriteStartArray();
            foreach (var item in Filters)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ComponentPurgeContent IJsonModel<ComponentPurgeContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComponentPurgeContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ComponentPurgeContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeComponentPurgeContent(document.RootElement, options);
        }

        internal static ComponentPurgeContent DeserializeComponentPurgeContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string table = default;
            IList<ComponentPurgeFilters> filters = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("table"u8))
                {
                    table = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("filters"u8))
                {
                    List<ComponentPurgeFilters> array = new List<ComponentPurgeFilters>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ComponentPurgeFilters.DeserializeComponentPurgeFilters(item, options));
                    }
                    filters = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ComponentPurgeContent(table, filters, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ComponentPurgeContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComponentPurgeContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ComponentPurgeContent)} does not support writing '{options.Format}' format.");
            }
        }

        ComponentPurgeContent IPersistableModel<ComponentPurgeContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComponentPurgeContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeComponentPurgeContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ComponentPurgeContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ComponentPurgeContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
