// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> Enum indicating the type of the Analytics item. </summary>
    public readonly partial struct ComponentItemType : IEquatable<ComponentItemType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComponentItemType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComponentItemType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string QueryValue = "query";
        private const string RecentValue = "recent";
        private const string FunctionValue = "function";

        /// <summary> none. </summary>
        public static ComponentItemType None { get; } = new ComponentItemType(NoneValue);
        /// <summary> query. </summary>
        public static ComponentItemType Query { get; } = new ComponentItemType(QueryValue);
        /// <summary> recent. </summary>
        public static ComponentItemType Recent { get; } = new ComponentItemType(RecentValue);
        /// <summary> function. </summary>
        public static ComponentItemType Function { get; } = new ComponentItemType(FunctionValue);
        /// <summary> Determines if two <see cref="ComponentItemType"/> values are the same. </summary>
        public static bool operator ==(ComponentItemType left, ComponentItemType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComponentItemType"/> values are not the same. </summary>
        public static bool operator !=(ComponentItemType left, ComponentItemType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComponentItemType"/>. </summary>
        public static implicit operator ComponentItemType(string value) => new ComponentItemType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComponentItemType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComponentItemType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
