// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </summary>
    public readonly partial struct ComponentItemScope : IEquatable<ComponentItemScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComponentItemScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComponentItemScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SharedValue = "shared";
        private const string UserValue = "user";

        /// <summary> shared. </summary>
        public static ComponentItemScope Shared { get; } = new ComponentItemScope(SharedValue);
        /// <summary> user. </summary>
        public static ComponentItemScope User { get; } = new ComponentItemScope(UserValue);
        /// <summary> Determines if two <see cref="ComponentItemScope"/> values are the same. </summary>
        public static bool operator ==(ComponentItemScope left, ComponentItemScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComponentItemScope"/> values are not the same. </summary>
        public static bool operator !=(ComponentItemScope left, ComponentItemScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComponentItemScope"/>. </summary>
        public static implicit operator ComponentItemScope(string value) => new ComponentItemScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComponentItemScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComponentItemScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
