// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> Indicates the flow of the ingestion. </summary>
    public readonly partial struct ComponentIngestionMode : IEquatable<ComponentIngestionMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComponentIngestionMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComponentIngestionMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApplicationInsightsValue = "ApplicationInsights";
        private const string ApplicationInsightsWithDiagnosticSettingsValue = "ApplicationInsightsWithDiagnosticSettings";
        private const string LogAnalyticsValue = "LogAnalytics";

        /// <summary> ApplicationInsights. </summary>
        public static ComponentIngestionMode ApplicationInsights { get; } = new ComponentIngestionMode(ApplicationInsightsValue);
        /// <summary> ApplicationInsightsWithDiagnosticSettings. </summary>
        public static ComponentIngestionMode ApplicationInsightsWithDiagnosticSettings { get; } = new ComponentIngestionMode(ApplicationInsightsWithDiagnosticSettingsValue);
        /// <summary> LogAnalytics. </summary>
        public static ComponentIngestionMode LogAnalytics { get; } = new ComponentIngestionMode(LogAnalyticsValue);
        /// <summary> Determines if two <see cref="ComponentIngestionMode"/> values are the same. </summary>
        public static bool operator ==(ComponentIngestionMode left, ComponentIngestionMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComponentIngestionMode"/> values are not the same. </summary>
        public static bool operator !=(ComponentIngestionMode left, ComponentIngestionMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComponentIngestionMode"/>. </summary>
        public static implicit operator ComponentIngestionMode(string value) => new ComponentIngestionMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComponentIngestionMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComponentIngestionMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
