// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API. </summary>
    public readonly partial struct ComponentFlowType : IEquatable<ComponentFlowType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComponentFlowType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComponentFlowType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BluefieldValue = "Bluefield";

        /// <summary> Bluefield. </summary>
        public static ComponentFlowType Bluefield { get; } = new ComponentFlowType(BluefieldValue);
        /// <summary> Determines if two <see cref="ComponentFlowType"/> values are the same. </summary>
        public static bool operator ==(ComponentFlowType left, ComponentFlowType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComponentFlowType"/> values are not the same. </summary>
        public static bool operator !=(ComponentFlowType left, ComponentFlowType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComponentFlowType"/>. </summary>
        public static implicit operator ComponentFlowType(string value) => new ComponentFlowType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComponentFlowType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComponentFlowType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
