// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    internal static partial class ComponentFavoriteTypeExtensions
    {
        public static string ToSerialString(this ComponentFavoriteType value) => value switch
        {
            ComponentFavoriteType.Shared => "shared",
            ComponentFavoriteType.User => "user",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ComponentFavoriteType value.")
        };

        public static ComponentFavoriteType ToComponentFavoriteType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "shared")) return ComponentFavoriteType.Shared;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "user")) return ComponentFavoriteType.User;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ComponentFavoriteType value.");
        }
    }
}
