// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> The parameters that can be provided when updating workbook properties properties. </summary>
    public partial class ApplicationInsightsWorkbookPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsWorkbookPatch"/>. </summary>
        public ApplicationInsightsWorkbookPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
            TagsPropertiesTags = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsWorkbookPatch"/>. </summary>
        /// <param name="kind"> The kind of workbook. Only valid value is shared. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="displayName"> The user-defined name (display name) of the workbook. </param>
        /// <param name="serializedData"> Configuration of this particular workbook. Configuration data is a string containing valid JSON. </param>
        /// <param name="category"> Workbook category, as defined by the user at creation time. </param>
        /// <param name="tagsPropertiesTags"> A list of 0 or more tags that are associated with this workbook definition. </param>
        /// <param name="description"> The description of the workbook. </param>
        /// <param name="revision"> The unique revision id for this workbook definition. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationInsightsWorkbookPatch(WorkbookUpdateSharedTypeKind? kind, IDictionary<string, string> tags, string displayName, string serializedData, string category, IList<string> tagsPropertiesTags, string description, string revision, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            Tags = tags;
            DisplayName = displayName;
            SerializedData = serializedData;
            Category = category;
            TagsPropertiesTags = tagsPropertiesTags;
            Description = description;
            Revision = revision;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The kind of workbook. Only valid value is shared. </summary>
        [WirePath("kind")]
        public WorkbookUpdateSharedTypeKind? Kind { get; set; }
        /// <summary> Resource tags. </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
        /// <summary> The user-defined name (display name) of the workbook. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> Configuration of this particular workbook. Configuration data is a string containing valid JSON. </summary>
        [WirePath("properties.serializedData")]
        public string SerializedData { get; set; }
        /// <summary> Workbook category, as defined by the user at creation time. </summary>
        [WirePath("properties.category")]
        public string Category { get; set; }
        /// <summary> A list of 0 or more tags that are associated with this workbook definition. </summary>
        [WirePath("properties.tags")]
        public IList<string> TagsPropertiesTags { get; }
        /// <summary> The description of the workbook. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> The unique revision id for this workbook definition. </summary>
        [WirePath("properties.revision")]
        public string Revision { get; set; }
    }
}
