// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> The network access type for operating on the Application Insights Component. By default it is Enabled. </summary>
    public readonly partial struct ApplicationInsightsPublicNetworkAccessType : IEquatable<ApplicationInsightsPublicNetworkAccessType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsPublicNetworkAccessType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApplicationInsightsPublicNetworkAccessType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enables connectivity to Application Insights through public DNS. </summary>
        public static ApplicationInsightsPublicNetworkAccessType Enabled { get; } = new ApplicationInsightsPublicNetworkAccessType(EnabledValue);
        /// <summary> Disables public connectivity to Application Insights through public DNS. </summary>
        public static ApplicationInsightsPublicNetworkAccessType Disabled { get; } = new ApplicationInsightsPublicNetworkAccessType(DisabledValue);
        /// <summary> Determines if two <see cref="ApplicationInsightsPublicNetworkAccessType"/> values are the same. </summary>
        public static bool operator ==(ApplicationInsightsPublicNetworkAccessType left, ApplicationInsightsPublicNetworkAccessType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApplicationInsightsPublicNetworkAccessType"/> values are not the same. </summary>
        public static bool operator !=(ApplicationInsightsPublicNetworkAccessType left, ApplicationInsightsPublicNetworkAccessType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApplicationInsightsPublicNetworkAccessType"/>. </summary>
        public static implicit operator ApplicationInsightsPublicNetworkAccessType(string value) => new ApplicationInsightsPublicNetworkAccessType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApplicationInsightsPublicNetworkAccessType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApplicationInsightsPublicNetworkAccessType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
