// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> Static definitions of the ProactiveDetection configuration rule (same values for all components). </summary>
    public partial class ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions"/>. </summary>
        public ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions"/>. </summary>
        /// <param name="name"> The rule name. </param>
        /// <param name="displayName"> The rule name as it is displayed in UI. </param>
        /// <param name="description"> The rule description. </param>
        /// <param name="helpUri"> URL which displays additional info about the proactive detection rule. </param>
        /// <param name="isHidden"> A flag indicating whether the rule is hidden (from the UI). </param>
        /// <param name="isEnabledByDefault"> A flag indicating whether the rule is enabled by default. </param>
        /// <param name="isInPreview"> A flag indicating whether the rule is in preview. </param>
        /// <param name="isEmailNotificationsSupported"> A flag indicating whether email notifications are supported for detections for this rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions(string name, string displayName, string description, Uri helpUri, bool? isHidden, bool? isEnabledByDefault, bool? isInPreview, bool? isEmailNotificationsSupported, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            DisplayName = displayName;
            Description = description;
            HelpUri = helpUri;
            IsHidden = isHidden;
            IsEnabledByDefault = isEnabledByDefault;
            IsInPreview = isInPreview;
            IsEmailNotificationsSupported = isEmailNotificationsSupported;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The rule name. </summary>
        [WirePath("Name")]
        public string Name { get; set; }
        /// <summary> The rule name as it is displayed in UI. </summary>
        [WirePath("DisplayName")]
        public string DisplayName { get; set; }
        /// <summary> The rule description. </summary>
        [WirePath("Description")]
        public string Description { get; set; }
        /// <summary> URL which displays additional info about the proactive detection rule. </summary>
        [WirePath("HelpUrl")]
        public Uri HelpUri { get; set; }
        /// <summary> A flag indicating whether the rule is hidden (from the UI). </summary>
        [WirePath("IsHidden")]
        public bool? IsHidden { get; set; }
        /// <summary> A flag indicating whether the rule is enabled by default. </summary>
        [WirePath("IsEnabledByDefault")]
        public bool? IsEnabledByDefault { get; set; }
        /// <summary> A flag indicating whether the rule is in preview. </summary>
        [WirePath("IsInPreview")]
        public bool? IsInPreview { get; set; }
        /// <summary> A flag indicating whether email notifications are supported for detections for this rule. </summary>
        [WirePath("SupportsEmailNotifications")]
        public bool? IsEmailNotificationsSupported { get; set; }
    }
}
