// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    public partial class ApplicationInsightsComponentFeatureCapabilities : IUtf8JsonSerializable, IJsonModel<ApplicationInsightsComponentFeatureCapabilities>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ApplicationInsightsComponentFeatureCapabilities>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ApplicationInsightsComponentFeatureCapabilities>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationInsightsComponentFeatureCapabilities>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApplicationInsightsComponentFeatureCapabilities)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(IsExportDataSupported))
            {
                writer.WritePropertyName("SupportExportData"u8);
                writer.WriteBooleanValue(IsExportDataSupported.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(BurstThrottlePolicy))
            {
                writer.WritePropertyName("BurstThrottlePolicy"u8);
                writer.WriteStringValue(BurstThrottlePolicy);
            }
            if (options.Format != "W" && Optional.IsDefined(MetadataClass))
            {
                writer.WritePropertyName("MetadataClass"u8);
                writer.WriteStringValue(MetadataClass);
            }
            if (options.Format != "W" && Optional.IsDefined(LiveStreamMetrics))
            {
                writer.WritePropertyName("LiveStreamMetrics"u8);
                writer.WriteBooleanValue(LiveStreamMetrics.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ApplicationMap))
            {
                writer.WritePropertyName("ApplicationMap"u8);
                writer.WriteBooleanValue(ApplicationMap.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(WorkItemIntegration))
            {
                writer.WritePropertyName("WorkItemIntegration"u8);
                writer.WriteBooleanValue(WorkItemIntegration.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PowerBIIntegration))
            {
                writer.WritePropertyName("PowerBIIntegration"u8);
                writer.WriteBooleanValue(PowerBIIntegration.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(OpenSchema))
            {
                writer.WritePropertyName("OpenSchema"u8);
                writer.WriteBooleanValue(OpenSchema.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProactiveDetection))
            {
                writer.WritePropertyName("ProactiveDetection"u8);
                writer.WriteBooleanValue(ProactiveDetection.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AnalyticsIntegration))
            {
                writer.WritePropertyName("AnalyticsIntegration"u8);
                writer.WriteBooleanValue(AnalyticsIntegration.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MultipleStepWebTest))
            {
                writer.WritePropertyName("MultipleStepWebTest"u8);
                writer.WriteBooleanValue(MultipleStepWebTest.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ApiAccessLevel))
            {
                writer.WritePropertyName("ApiAccessLevel"u8);
                writer.WriteStringValue(ApiAccessLevel);
            }
            if (options.Format != "W" && Optional.IsDefined(TrackingType))
            {
                writer.WritePropertyName("TrackingType"u8);
                writer.WriteStringValue(TrackingType);
            }
            if (options.Format != "W" && Optional.IsDefined(DailyCap))
            {
                writer.WritePropertyName("DailyCap"u8);
                writer.WriteNumberValue(DailyCap.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(DailyCapResetTime))
            {
                writer.WritePropertyName("DailyCapResetTime"u8);
                writer.WriteNumberValue(DailyCapResetTime.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ThrottleRate))
            {
                writer.WritePropertyName("ThrottleRate"u8);
                writer.WriteNumberValue(ThrottleRate.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ApplicationInsightsComponentFeatureCapabilities IJsonModel<ApplicationInsightsComponentFeatureCapabilities>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationInsightsComponentFeatureCapabilities>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApplicationInsightsComponentFeatureCapabilities)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeApplicationInsightsComponentFeatureCapabilities(document.RootElement, options);
        }

        internal static ApplicationInsightsComponentFeatureCapabilities DeserializeApplicationInsightsComponentFeatureCapabilities(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? supportExportData = default;
            string burstThrottlePolicy = default;
            string metadataClass = default;
            bool? liveStreamMetrics = default;
            bool? applicationMap = default;
            bool? workItemIntegration = default;
            bool? powerBIIntegration = default;
            bool? openSchema = default;
            bool? proactiveDetection = default;
            bool? analyticsIntegration = default;
            bool? multipleStepWebTest = default;
            string apiAccessLevel = default;
            string trackingType = default;
            float? dailyCap = default;
            float? dailyCapResetTime = default;
            float? throttleRate = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("SupportExportData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportExportData = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("BurstThrottlePolicy"u8))
                {
                    burstThrottlePolicy = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("MetadataClass"u8))
                {
                    metadataClass = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("LiveStreamMetrics"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    liveStreamMetrics = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("ApplicationMap"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    applicationMap = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("WorkItemIntegration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    workItemIntegration = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("PowerBIIntegration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    powerBIIntegration = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("OpenSchema"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    openSchema = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("ProactiveDetection"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    proactiveDetection = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("AnalyticsIntegration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    analyticsIntegration = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("MultipleStepWebTest"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    multipleStepWebTest = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("ApiAccessLevel"u8))
                {
                    apiAccessLevel = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("TrackingType"u8))
                {
                    trackingType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("DailyCap"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dailyCap = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("DailyCapResetTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dailyCapResetTime = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("ThrottleRate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    throttleRate = property.Value.GetSingle();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ApplicationInsightsComponentFeatureCapabilities(
                supportExportData,
                burstThrottlePolicy,
                metadataClass,
                liveStreamMetrics,
                applicationMap,
                workItemIntegration,
                powerBIIntegration,
                openSchema,
                proactiveDetection,
                analyticsIntegration,
                multipleStepWebTest,
                apiAccessLevel,
                trackingType,
                dailyCap,
                dailyCapResetTime,
                throttleRate,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsExportDataSupported), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  SupportExportData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsExportDataSupported))
                {
                    builder.Append("  SupportExportData: ");
                    var boolValue = IsExportDataSupported.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BurstThrottlePolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  BurstThrottlePolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BurstThrottlePolicy))
                {
                    builder.Append("  BurstThrottlePolicy: ");
                    if (BurstThrottlePolicy.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BurstThrottlePolicy}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BurstThrottlePolicy}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MetadataClass), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  MetadataClass: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MetadataClass))
                {
                    builder.Append("  MetadataClass: ");
                    if (MetadataClass.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MetadataClass}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MetadataClass}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LiveStreamMetrics), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  LiveStreamMetrics: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LiveStreamMetrics))
                {
                    builder.Append("  LiveStreamMetrics: ");
                    var boolValue = LiveStreamMetrics.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApplicationMap), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ApplicationMap: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ApplicationMap))
                {
                    builder.Append("  ApplicationMap: ");
                    var boolValue = ApplicationMap.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WorkItemIntegration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  WorkItemIntegration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WorkItemIntegration))
                {
                    builder.Append("  WorkItemIntegration: ");
                    var boolValue = WorkItemIntegration.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PowerBIIntegration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  PowerBIIntegration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PowerBIIntegration))
                {
                    builder.Append("  PowerBIIntegration: ");
                    var boolValue = PowerBIIntegration.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OpenSchema), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  OpenSchema: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OpenSchema))
                {
                    builder.Append("  OpenSchema: ");
                    var boolValue = OpenSchema.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProactiveDetection), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ProactiveDetection: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProactiveDetection))
                {
                    builder.Append("  ProactiveDetection: ");
                    var boolValue = ProactiveDetection.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AnalyticsIntegration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  AnalyticsIntegration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AnalyticsIntegration))
                {
                    builder.Append("  AnalyticsIntegration: ");
                    var boolValue = AnalyticsIntegration.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MultipleStepWebTest), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  MultipleStepWebTest: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MultipleStepWebTest))
                {
                    builder.Append("  MultipleStepWebTest: ");
                    var boolValue = MultipleStepWebTest.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApiAccessLevel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ApiAccessLevel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ApiAccessLevel))
                {
                    builder.Append("  ApiAccessLevel: ");
                    if (ApiAccessLevel.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ApiAccessLevel}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ApiAccessLevel}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TrackingType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  TrackingType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TrackingType))
                {
                    builder.Append("  TrackingType: ");
                    if (TrackingType.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TrackingType}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TrackingType}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DailyCap), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  DailyCap: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DailyCap))
                {
                    builder.Append("  DailyCap: ");
                    builder.AppendLine($"'{DailyCap.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DailyCapResetTime), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  DailyCapResetTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DailyCapResetTime))
                {
                    builder.Append("  DailyCapResetTime: ");
                    builder.AppendLine($"'{DailyCapResetTime.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ThrottleRate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ThrottleRate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ThrottleRate))
                {
                    builder.Append("  ThrottleRate: ");
                    builder.AppendLine($"'{ThrottleRate.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ApplicationInsightsComponentFeatureCapabilities>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationInsightsComponentFeatureCapabilities>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ApplicationInsightsComponentFeatureCapabilities)} does not support writing '{options.Format}' format.");
            }
        }

        ApplicationInsightsComponentFeatureCapabilities IPersistableModel<ApplicationInsightsComponentFeatureCapabilities>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationInsightsComponentFeatureCapabilities>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeApplicationInsightsComponentFeatureCapabilities(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ApplicationInsightsComponentFeatureCapabilities)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ApplicationInsightsComponentFeatureCapabilities>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
