// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> An Application Insights component daily data volume cap status. </summary>
    public partial class ApplicationInsightsComponentFeature
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsComponentFeature"/>. </summary>
        internal ApplicationInsightsComponentFeature()
        {
            Capabilities = new ChangeTrackingList<ApplicationInsightsComponentFeatureCapability>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsComponentFeature"/>. </summary>
        /// <param name="featureName"> The pricing feature name. </param>
        /// <param name="meterId"> The meter id used for the feature. </param>
        /// <param name="meterRateFrequency"> The meter rate for the feature's meter. </param>
        /// <param name="resourceId"> Reserved, not used now. </param>
        /// <param name="isHidden"> Reserved, not used now. </param>
        /// <param name="capabilities"> A list of Application Insights component feature capability. </param>
        /// <param name="title"> Display name of the feature. </param>
        /// <param name="isMainFeature"> Whether can apply addon feature on to it. </param>
        /// <param name="supportedAddonFeatures"> The add on features on main feature. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationInsightsComponentFeature(string featureName, string meterId, string meterRateFrequency, ResourceIdentifier resourceId, bool? isHidden, IReadOnlyList<ApplicationInsightsComponentFeatureCapability> capabilities, string title, bool? isMainFeature, string supportedAddonFeatures, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FeatureName = featureName;
            MeterId = meterId;
            MeterRateFrequency = meterRateFrequency;
            ResourceId = resourceId;
            IsHidden = isHidden;
            Capabilities = capabilities;
            Title = title;
            IsMainFeature = isMainFeature;
            SupportedAddonFeatures = supportedAddonFeatures;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The pricing feature name. </summary>
        [WirePath("FeatureName")]
        public string FeatureName { get; }
        /// <summary> The meter id used for the feature. </summary>
        [WirePath("MeterId")]
        public string MeterId { get; }
        /// <summary> The meter rate for the feature's meter. </summary>
        [WirePath("MeterRateFrequency")]
        public string MeterRateFrequency { get; }
        /// <summary> Reserved, not used now. </summary>
        [WirePath("ResouceId")]
        public ResourceIdentifier ResourceId { get; }
        /// <summary> Reserved, not used now. </summary>
        [WirePath("IsHidden")]
        public bool? IsHidden { get; }
        /// <summary> A list of Application Insights component feature capability. </summary>
        [WirePath("Capabilities")]
        public IReadOnlyList<ApplicationInsightsComponentFeatureCapability> Capabilities { get; }
        /// <summary> Display name of the feature. </summary>
        [WirePath("Title")]
        public string Title { get; }
        /// <summary> Whether can apply addon feature on to it. </summary>
        [WirePath("IsMainFeature")]
        public bool? IsMainFeature { get; }
        /// <summary> The add on features on main feature. </summary>
        [WirePath("SupportedAddonFeatures")]
        public string SupportedAddonFeatures { get; }
    }
}
