// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> Properties that define an Analytics item that is associated to an Application Insights component. </summary>
    public partial class ApplicationInsightsComponentAnalyticsItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsComponentAnalyticsItem"/>. </summary>
        public ApplicationInsightsComponentAnalyticsItem()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsComponentAnalyticsItem"/>. </summary>
        /// <param name="id"> Internally assigned unique id of the item definition. </param>
        /// <param name="name"> The user-defined name of the item. </param>
        /// <param name="content"> The content of this item. </param>
        /// <param name="version"> This instance's version of the data model. This can change as new features are added. </param>
        /// <param name="scope"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="componentItemType"> Enum indicating the type of the Analytics item. </param>
        /// <param name="createdOn"> Date and time in UTC when this item was created. </param>
        /// <param name="modifiedOn"> Date and time in UTC of the last modification that was made to this item. </param>
        /// <param name="properties"> A set of properties that can be defined in the context of a specific item type. Each type may have its own properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationInsightsComponentAnalyticsItem(string id, string name, string content, string version, ComponentItemScope? scope, ComponentItemType? componentItemType, DateTimeOffset? createdOn, DateTimeOffset? modifiedOn, ApplicationInsightsComponentAnalyticsItemProperties properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            Content = content;
            Version = version;
            Scope = scope;
            ComponentItemType = componentItemType;
            CreatedOn = createdOn;
            ModifiedOn = modifiedOn;
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Internally assigned unique id of the item definition. </summary>
        [WirePath("Id")]
        public string Id { get; set; }
        /// <summary> The user-defined name of the item. </summary>
        [WirePath("Name")]
        public string Name { get; set; }
        /// <summary> The content of this item. </summary>
        [WirePath("Content")]
        public string Content { get; set; }
        /// <summary> This instance's version of the data model. This can change as new features are added. </summary>
        [WirePath("Version")]
        public string Version { get; }
        /// <summary> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </summary>
        [WirePath("Scope")]
        public ComponentItemScope? Scope { get; set; }
        /// <summary> Enum indicating the type of the Analytics item. </summary>
        [WirePath("Type")]
        public ComponentItemType? ComponentItemType { get; set; }
        /// <summary> Date and time in UTC when this item was created. </summary>
        [WirePath("TimeCreated")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Date and time in UTC of the last modification that was made to this item. </summary>
        [WirePath("TimeModified")]
        public DateTimeOffset? ModifiedOn { get; }
        /// <summary> A set of properties that can be defined in the context of a specific item type. Each type may have its own properties. </summary>
        internal ApplicationInsightsComponentAnalyticsItemProperties Properties { get; set; }
        /// <summary> A function alias, used when the type of the item is Function. </summary>
        [WirePath("Properties.functionAlias")]
        public string ApplicationInsightsComponentAnalyticsItemFunctionAlias
        {
            get => Properties is null ? default : Properties.FunctionAlias;
            set
            {
                if (Properties is null)
                    Properties = new ApplicationInsightsComponentAnalyticsItemProperties();
                Properties.FunctionAlias = value;
            }
        }
    }
}
