// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> Type of application being monitored. </summary>
    public readonly partial struct ApplicationInsightsApplicationType : IEquatable<ApplicationInsightsApplicationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsApplicationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApplicationInsightsApplicationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WebValue = "web";
        private const string OtherValue = "other";

        /// <summary> web. </summary>
        public static ApplicationInsightsApplicationType Web { get; } = new ApplicationInsightsApplicationType(WebValue);
        /// <summary> other. </summary>
        public static ApplicationInsightsApplicationType Other { get; } = new ApplicationInsightsApplicationType(OtherValue);
        /// <summary> Determines if two <see cref="ApplicationInsightsApplicationType"/> values are the same. </summary>
        public static bool operator ==(ApplicationInsightsApplicationType left, ApplicationInsightsApplicationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApplicationInsightsApplicationType"/> values are not the same. </summary>
        public static bool operator !=(ApplicationInsightsApplicationType left, ApplicationInsightsApplicationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApplicationInsightsApplicationType"/>. </summary>
        public static implicit operator ApplicationInsightsApplicationType(string value) => new ApplicationInsightsApplicationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApplicationInsightsApplicationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApplicationInsightsApplicationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
