// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> Annotation associated with an application insights resource. </summary>
    public partial class ApplicationInsightsAnnotation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsAnnotation"/>. </summary>
        public ApplicationInsightsAnnotation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsAnnotation"/>. </summary>
        /// <param name="annotationName"> Name of annotation. </param>
        /// <param name="category"> Category of annotation, free form. </param>
        /// <param name="eventOccurredOn"> Time when event occurred. </param>
        /// <param name="id"> Unique Id for annotation. </param>
        /// <param name="properties"> Serialized JSON object for detailed properties. </param>
        /// <param name="relatedAnnotation"> Related parent annotation if any. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationInsightsAnnotation(string annotationName, string category, DateTimeOffset? eventOccurredOn, string id, string properties, string relatedAnnotation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AnnotationName = annotationName;
            Category = category;
            EventOccurredOn = eventOccurredOn;
            Id = id;
            Properties = properties;
            RelatedAnnotation = relatedAnnotation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of annotation. </summary>
        [WirePath("AnnotationName")]
        public string AnnotationName { get; set; }
        /// <summary> Category of annotation, free form. </summary>
        [WirePath("Category")]
        public string Category { get; set; }
        /// <summary> Time when event occurred. </summary>
        [WirePath("EventTime")]
        public DateTimeOffset? EventOccurredOn { get; set; }
        /// <summary> Unique Id for annotation. </summary>
        [WirePath("Id")]
        public string Id { get; set; }
        /// <summary> Serialized JSON object for detailed properties. </summary>
        [WirePath("Properties")]
        public string Properties { get; set; }
        /// <summary> Related parent annotation if any. </summary>
        [WirePath("RelatedAnnotation")]
        public string RelatedAnnotation { get; set; }
    }
}
