// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApplicationInsights.Models
{
    /// <summary> The AnalyticsItemScopePath. </summary>
    public readonly partial struct AnalyticsItemScopePath : IEquatable<AnalyticsItemScopePath>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyticsItemScopePath"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyticsItemScopePath(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnalyticsItemsValue = "analyticsItems";
        private const string MyAnalyticsItemsValue = "myanalyticsItems";

        /// <summary> analyticsItems. </summary>
        public static AnalyticsItemScopePath AnalyticsItems { get; } = new AnalyticsItemScopePath(AnalyticsItemsValue);
        /// <summary> myanalyticsItems. </summary>
        public static AnalyticsItemScopePath MyAnalyticsItems { get; } = new AnalyticsItemScopePath(MyAnalyticsItemsValue);
        /// <summary> Determines if two <see cref="AnalyticsItemScopePath"/> values are the same. </summary>
        public static bool operator ==(AnalyticsItemScopePath left, AnalyticsItemScopePath right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyticsItemScopePath"/> values are not the same. </summary>
        public static bool operator !=(AnalyticsItemScopePath left, AnalyticsItemScopePath right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyticsItemScopePath"/>. </summary>
        public static implicit operator AnalyticsItemScopePath(string value) => new AnalyticsItemScopePath(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyticsItemScopePath other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyticsItemScopePath other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
