// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ApplicationInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApplicationInsights
{
    /// <summary>
    /// A class representing the ApplicationInsightsWebTest data model.
    /// An Application Insights WebTest definition.
    /// </summary>
    public partial class ApplicationInsightsWebTestData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsWebTestData"/>. </summary>
        /// <param name="location"> The location. </param>
        public ApplicationInsightsWebTestData(AzureLocation location) : base(location)
        {
            Locations = new ChangeTrackingList<WebTestGeolocation>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsWebTestData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> The kind of WebTest that this web test watches. Choices are ping, multistep and standard. </param>
        /// <param name="syntheticMonitorId"> Unique ID of this WebTest. This is typically the same value as the Name field. </param>
        /// <param name="webTestName"> User defined name if this WebTest. </param>
        /// <param name="description"> User defined description for this WebTest. </param>
        /// <param name="isEnabled"> Is the test actively being monitored. </param>
        /// <param name="frequencyInSeconds"> Interval in seconds between test runs for this WebTest. Default value is 300. </param>
        /// <param name="timeoutInSeconds"> Seconds until this WebTest will timeout and fail. Default value is 30. </param>
        /// <param name="webTestKind"> The kind of web test this is, valid choices are ping, multistep and standard. </param>
        /// <param name="isRetryEnabled"> Allow for retries should this WebTest fail. </param>
        /// <param name="locations"> A list of where to physically run the tests from to give global coverage for accessibility of your application. </param>
        /// <param name="configuration"> An XML configuration specification for a WebTest. </param>
        /// <param name="provisioningState"> Current state of this component, whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed. </param>
        /// <param name="request"> The collection of request properties. </param>
        /// <param name="validationRules"> The collection of validation rule properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationInsightsWebTestData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, WebTestKind? kind, string syntheticMonitorId, string webTestName, string description, bool? isEnabled, int? frequencyInSeconds, int? timeoutInSeconds, WebTestKind? webTestKind, bool? isRetryEnabled, IList<WebTestGeolocation> locations, WebTestConfiguration configuration, string provisioningState, WebTestRequest request, WebTestValidationRules validationRules, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Kind = kind;
            SyntheticMonitorId = syntheticMonitorId;
            WebTestName = webTestName;
            Description = description;
            IsEnabled = isEnabled;
            FrequencyInSeconds = frequencyInSeconds;
            TimeoutInSeconds = timeoutInSeconds;
            WebTestKind = webTestKind;
            IsRetryEnabled = isRetryEnabled;
            Locations = locations;
            Configuration = configuration;
            ProvisioningState = provisioningState;
            Request = request;
            ValidationRules = validationRules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsWebTestData"/> for deserialization. </summary>
        internal ApplicationInsightsWebTestData()
        {
        }

        /// <summary> The kind of WebTest that this web test watches. Choices are ping, multistep and standard. </summary>
        [WirePath("kind")]
        public WebTestKind? Kind { get; set; }
        /// <summary> Unique ID of this WebTest. This is typically the same value as the Name field. </summary>
        [WirePath("properties.SyntheticMonitorId")]
        public string SyntheticMonitorId { get; set; }
        /// <summary> User defined name if this WebTest. </summary>
        [WirePath("properties.Name")]
        public string WebTestName { get; set; }
        /// <summary> User defined description for this WebTest. </summary>
        [WirePath("properties.Description")]
        public string Description { get; set; }
        /// <summary> Is the test actively being monitored. </summary>
        [WirePath("properties.Enabled")]
        public bool? IsEnabled { get; set; }
        /// <summary> Interval in seconds between test runs for this WebTest. Default value is 300. </summary>
        [WirePath("properties.Frequency")]
        public int? FrequencyInSeconds { get; set; }
        /// <summary> Seconds until this WebTest will timeout and fail. Default value is 30. </summary>
        [WirePath("properties.Timeout")]
        public int? TimeoutInSeconds { get; set; }
        /// <summary> The kind of web test this is, valid choices are ping, multistep and standard. </summary>
        [WirePath("properties.Kind")]
        public WebTestKind? WebTestKind { get; set; }
        /// <summary> Allow for retries should this WebTest fail. </summary>
        [WirePath("properties.RetryEnabled")]
        public bool? IsRetryEnabled { get; set; }
        /// <summary> A list of where to physically run the tests from to give global coverage for accessibility of your application. </summary>
        [WirePath("properties.Locations")]
        public IList<WebTestGeolocation> Locations { get; }
        /// <summary> An XML configuration specification for a WebTest. </summary>
        internal WebTestConfiguration Configuration { get; set; }
        /// <summary> The XML specification of a WebTest to run against an application. </summary>
        [WirePath("properties.Configuration.WebTest")]
        public string WebTest
        {
            get => Configuration is null ? default : Configuration.WebTest;
            set
            {
                if (Configuration is null)
                    Configuration = new WebTestConfiguration();
                Configuration.WebTest = value;
            }
        }

        /// <summary> Current state of this component, whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed. </summary>
        [WirePath("properties.provisioningState")]
        public string ProvisioningState { get; }
        /// <summary> The collection of request properties. </summary>
        [WirePath("properties.Request")]
        public WebTestRequest Request { get; set; }
        /// <summary> The collection of validation rule properties. </summary>
        [WirePath("properties.ValidationRules")]
        public WebTestValidationRules ValidationRules { get; set; }
    }
}
