// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ApplicationInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="ApplicationInsightsWebTestResource"/> and their operations.
    /// Each <see cref="ApplicationInsightsWebTestResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get an <see cref="ApplicationInsightsWebTestCollection"/> instance call the GetApplicationInsightsWebTests method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class ApplicationInsightsWebTestCollection : ArmCollection, IEnumerable<ApplicationInsightsWebTestResource>, IAsyncEnumerable<ApplicationInsightsWebTestResource>
    {
        private readonly ClientDiagnostics _applicationInsightsWebTestWebTestsClientDiagnostics;
        private readonly WebTestsRestOperations _applicationInsightsWebTestWebTestsRestClient;

        /// <summary> Initializes a new instance of the <see cref="ApplicationInsightsWebTestCollection"/> class for mocking. </summary>
        protected ApplicationInsightsWebTestCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ApplicationInsightsWebTestCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ApplicationInsightsWebTestCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _applicationInsightsWebTestWebTestsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ApplicationInsightsWebTestResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ApplicationInsightsWebTestResource.ResourceType, out string applicationInsightsWebTestWebTestsApiVersion);
            _applicationInsightsWebTestWebTestsRestClient = new WebTestsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, applicationInsightsWebTestWebTestsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates an Application Insights web test definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="webTestName"> The name of the Application Insights WebTest resource. </param>
        /// <param name="data"> Properties that need to be specified to create or update an Application Insights web test definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webTestName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ApplicationInsightsWebTestResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string webTestName, ApplicationInsightsWebTestData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webTestName, nameof(webTestName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _applicationInsightsWebTestWebTestsClientDiagnostics.CreateScope("ApplicationInsightsWebTestCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _applicationInsightsWebTestWebTestsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, webTestName, data, cancellationToken).ConfigureAwait(false);
                var uri = _applicationInsightsWebTestWebTestsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, webTestName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApplicationInsightsArmOperation<ApplicationInsightsWebTestResource>(Response.FromValue(new ApplicationInsightsWebTestResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates an Application Insights web test definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="webTestName"> The name of the Application Insights WebTest resource. </param>
        /// <param name="data"> Properties that need to be specified to create or update an Application Insights web test definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webTestName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ApplicationInsightsWebTestResource> CreateOrUpdate(WaitUntil waitUntil, string webTestName, ApplicationInsightsWebTestData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webTestName, nameof(webTestName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _applicationInsightsWebTestWebTestsClientDiagnostics.CreateScope("ApplicationInsightsWebTestCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _applicationInsightsWebTestWebTestsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, webTestName, data, cancellationToken);
                var uri = _applicationInsightsWebTestWebTestsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, webTestName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApplicationInsightsArmOperation<ApplicationInsightsWebTestResource>(Response.FromValue(new ApplicationInsightsWebTestResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a specific Application Insights web test definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webTestName"> The name of the Application Insights WebTest resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webTestName"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsWebTestResource>> GetAsync(string webTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webTestName, nameof(webTestName));

            using var scope = _applicationInsightsWebTestWebTestsClientDiagnostics.CreateScope("ApplicationInsightsWebTestCollection.Get");
            scope.Start();
            try
            {
                var response = await _applicationInsightsWebTestWebTestsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, webTestName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ApplicationInsightsWebTestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a specific Application Insights web test definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webTestName"> The name of the Application Insights WebTest resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webTestName"/> is null. </exception>
        public virtual Response<ApplicationInsightsWebTestResource> Get(string webTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webTestName, nameof(webTestName));

            using var scope = _applicationInsightsWebTestWebTestsClientDiagnostics.CreateScope("ApplicationInsightsWebTestCollection.Get");
            scope.Start();
            try
            {
                var response = _applicationInsightsWebTestWebTestsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, webTestName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ApplicationInsightsWebTestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get all Application Insights web tests defined for the specified resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ApplicationInsightsWebTestResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsWebTestResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _applicationInsightsWebTestWebTestsRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _applicationInsightsWebTestWebTestsRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ApplicationInsightsWebTestResource(Client, ApplicationInsightsWebTestData.DeserializeApplicationInsightsWebTestData(e)), _applicationInsightsWebTestWebTestsClientDiagnostics, Pipeline, "ApplicationInsightsWebTestCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Get all Application Insights web tests defined for the specified resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ApplicationInsightsWebTestResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsWebTestResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _applicationInsightsWebTestWebTestsRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _applicationInsightsWebTestWebTestsRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ApplicationInsightsWebTestResource(Client, ApplicationInsightsWebTestData.DeserializeApplicationInsightsWebTestData(e)), _applicationInsightsWebTestWebTestsClientDiagnostics, Pipeline, "ApplicationInsightsWebTestCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webTestName"> The name of the Application Insights WebTest resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webTestName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string webTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webTestName, nameof(webTestName));

            using var scope = _applicationInsightsWebTestWebTestsClientDiagnostics.CreateScope("ApplicationInsightsWebTestCollection.Exists");
            scope.Start();
            try
            {
                var response = await _applicationInsightsWebTestWebTestsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, webTestName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webTestName"> The name of the Application Insights WebTest resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webTestName"/> is null. </exception>
        public virtual Response<bool> Exists(string webTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webTestName, nameof(webTestName));

            using var scope = _applicationInsightsWebTestWebTestsClientDiagnostics.CreateScope("ApplicationInsightsWebTestCollection.Exists");
            scope.Start();
            try
            {
                var response = _applicationInsightsWebTestWebTestsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, webTestName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webTestName"> The name of the Application Insights WebTest resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webTestName"/> is null. </exception>
        public virtual async Task<NullableResponse<ApplicationInsightsWebTestResource>> GetIfExistsAsync(string webTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webTestName, nameof(webTestName));

            using var scope = _applicationInsightsWebTestWebTestsClientDiagnostics.CreateScope("ApplicationInsightsWebTestCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _applicationInsightsWebTestWebTestsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, webTestName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ApplicationInsightsWebTestResource>(response.GetRawResponse());
                return Response.FromValue(new ApplicationInsightsWebTestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="webTestName"> The name of the Application Insights WebTest resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="webTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="webTestName"/> is null. </exception>
        public virtual NullableResponse<ApplicationInsightsWebTestResource> GetIfExists(string webTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(webTestName, nameof(webTestName));

            using var scope = _applicationInsightsWebTestWebTestsClientDiagnostics.CreateScope("ApplicationInsightsWebTestCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _applicationInsightsWebTestWebTestsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, webTestName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ApplicationInsightsWebTestResource>(response.GetRawResponse());
                return Response.FromValue(new ApplicationInsightsWebTestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ApplicationInsightsWebTestResource> IEnumerable<ApplicationInsightsWebTestResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ApplicationInsightsWebTestResource> IAsyncEnumerable<ApplicationInsightsWebTestResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
