// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ApplicationInsights.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ApplicationInsights
{
    /// <summary>
    /// A Class representing an ApplicationInsightsComponent along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct an <see cref="ApplicationInsightsComponentResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetApplicationInsightsComponentResource method.
    /// Otherwise you can get one from its parent resource <see cref="ResourceGroupResource"/> using the GetApplicationInsightsComponent method.
    /// </summary>
    public partial class ApplicationInsightsComponentResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="ApplicationInsightsComponentResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="resourceName"> The resourceName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string resourceName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _applicationInsightsComponentComponentsClientDiagnostics;
        private readonly ComponentsRestOperations _applicationInsightsComponentComponentsRestClient;
        private readonly ClientDiagnostics _annotationsClientDiagnostics;
        private readonly AnnotationsRestOperations _annotationsRestClient;
        private readonly ClientDiagnostics _apiKeysClientDiagnostics;
        private readonly APIKeysRestOperations _apiKeysRestClient;
        private readonly ClientDiagnostics _exportConfigurationsClientDiagnostics;
        private readonly ExportConfigurationsRestOperations _exportConfigurationsRestClient;
        private readonly ClientDiagnostics _componentCurrentBillingFeaturesClientDiagnostics;
        private readonly ComponentCurrentBillingFeaturesRestOperations _componentCurrentBillingFeaturesRestClient;
        private readonly ClientDiagnostics _componentQuotaStatusClientDiagnostics;
        private readonly ComponentQuotaStatusRestOperations _componentQuotaStatusRestClient;
        private readonly ClientDiagnostics _componentFeatureCapabilitiesClientDiagnostics;
        private readonly ComponentFeatureCapabilitiesRestOperations _componentFeatureCapabilitiesRestClient;
        private readonly ClientDiagnostics _componentAvailableFeaturesClientDiagnostics;
        private readonly ComponentAvailableFeaturesRestOperations _componentAvailableFeaturesRestClient;
        private readonly ClientDiagnostics _proactiveDetectionConfigurationsClientDiagnostics;
        private readonly ProactiveDetectionConfigurationsRestOperations _proactiveDetectionConfigurationsRestClient;
        private readonly ClientDiagnostics _workItemConfigurationsClientDiagnostics;
        private readonly WorkItemConfigurationsRestOperations _workItemConfigurationsRestClient;
        private readonly ClientDiagnostics _favoritesClientDiagnostics;
        private readonly FavoritesRestOperations _favoritesRestClient;
        private readonly ClientDiagnostics _webTestLocationsClientDiagnostics;
        private readonly WebTestLocationsRestOperations _webTestLocationsRestClient;
        private readonly ClientDiagnostics _applicationInsightsWebTestWebTestsClientDiagnostics;
        private readonly WebTestsRestOperations _applicationInsightsWebTestWebTestsRestClient;
        private readonly ClientDiagnostics _analyticsItemsClientDiagnostics;
        private readonly AnalyticsItemsRestOperations _analyticsItemsRestClient;
        private readonly ApplicationInsightsComponentData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Insights/components";

        /// <summary> Initializes a new instance of the <see cref="ApplicationInsightsComponentResource"/> class for mocking. </summary>
        protected ApplicationInsightsComponentResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ApplicationInsightsComponentResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal ApplicationInsightsComponentResource(ArmClient client, ApplicationInsightsComponentData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="ApplicationInsightsComponentResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal ApplicationInsightsComponentResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _applicationInsightsComponentComponentsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string applicationInsightsComponentComponentsApiVersion);
            _applicationInsightsComponentComponentsRestClient = new ComponentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, applicationInsightsComponentComponentsApiVersion);
            _annotationsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _annotationsRestClient = new AnnotationsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _apiKeysClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _apiKeysRestClient = new APIKeysRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _exportConfigurationsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _exportConfigurationsRestClient = new ExportConfigurationsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _componentCurrentBillingFeaturesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _componentCurrentBillingFeaturesRestClient = new ComponentCurrentBillingFeaturesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _componentQuotaStatusClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _componentQuotaStatusRestClient = new ComponentQuotaStatusRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _componentFeatureCapabilitiesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _componentFeatureCapabilitiesRestClient = new ComponentFeatureCapabilitiesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _componentAvailableFeaturesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _componentAvailableFeaturesRestClient = new ComponentAvailableFeaturesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _proactiveDetectionConfigurationsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _proactiveDetectionConfigurationsRestClient = new ProactiveDetectionConfigurationsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _workItemConfigurationsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _workItemConfigurationsRestClient = new WorkItemConfigurationsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _favoritesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _favoritesRestClient = new FavoritesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _webTestLocationsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _webTestLocationsRestClient = new WebTestLocationsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _applicationInsightsWebTestWebTestsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ApplicationInsightsWebTestResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ApplicationInsightsWebTestResource.ResourceType, out string applicationInsightsWebTestWebTestsApiVersion);
            _applicationInsightsWebTestWebTestsRestClient = new WebTestsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, applicationInsightsWebTestWebTestsApiVersion);
            _analyticsItemsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApplicationInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _analyticsItemsRestClient = new AnalyticsItemsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual ApplicationInsightsComponentData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Returns an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ApplicationInsightsComponentResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.Get");
            scope.Start();
            try
            {
                var response = await _applicationInsightsComponentComponentsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ApplicationInsightsComponentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ApplicationInsightsComponentResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.Get");
            scope.Start();
            try
            {
                var response = _applicationInsightsComponentComponentsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ApplicationInsightsComponentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.Delete");
            scope.Start();
            try
            {
                var response = await _applicationInsightsComponentComponentsRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                var uri = _applicationInsightsComponentComponentsRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApplicationInsightsArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.Delete");
            scope.Start();
            try
            {
                var response = _applicationInsightsComponentComponentsRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                var uri = _applicationInsightsComponentComponentsRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApplicationInsightsArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates an existing component's tags. To update other fields use the CreateOrUpdate method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_UpdateTags</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="componentTags"> Updated tag information to set into the component instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="componentTags"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentResource>> UpdateAsync(WebTestComponentTag componentTags, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(componentTags, nameof(componentTags));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.Update");
            scope.Start();
            try
            {
                var response = await _applicationInsightsComponentComponentsRestClient.UpdateTagsAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, componentTags, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new ApplicationInsightsComponentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates an existing component's tags. To update other fields use the CreateOrUpdate method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_UpdateTags</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="componentTags"> Updated tag information to set into the component instance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="componentTags"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentResource> Update(WebTestComponentTag componentTags, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(componentTags, nameof(componentTags));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.Update");
            scope.Start();
            try
            {
                var response = _applicationInsightsComponentComponentsRestClient.UpdateTags(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, componentTags, cancellationToken);
                return Response.FromValue(new ApplicationInsightsComponentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Purges data in an Application Insights component by a set of user-defined filters.
        ///
        /// In order to manage system resources, purge requests are throttled at 50 requests per hour. You should batch the execution of purge requests by sending a single command whose predicate includes all user identities that require purging. Use the in operator to specify multiple identities. You should run the query prior to using for a purge request to verify that the results are expected.
        /// Note: this operation is intended for Classic resources, for  workspace-based Application Insights resource please run purge operation (directly on the workspace)(https://docs.microsoft.com/en-us/rest/api/loganalytics/workspace-purge/purge) , scoped to specific resource id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/purge</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Purge</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Describes the body of a request to purge data in a single table of an Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<ComponentPurgeResult>> PurgeAsync(ComponentPurgeContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.Purge");
            scope.Start();
            try
            {
                var response = await _applicationInsightsComponentComponentsRestClient.PurgeAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Purges data in an Application Insights component by a set of user-defined filters.
        ///
        /// In order to manage system resources, purge requests are throttled at 50 requests per hour. You should batch the execution of purge requests by sending a single command whose predicate includes all user identities that require purging. Use the in operator to specify multiple identities. You should run the query prior to using for a purge request to verify that the results are expected.
        /// Note: this operation is intended for Classic resources, for  workspace-based Application Insights resource please run purge operation (directly on the workspace)(https://docs.microsoft.com/en-us/rest/api/loganalytics/workspace-purge/purge) , scoped to specific resource id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/purge</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Purge</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Describes the body of a request to purge data in a single table of an Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual Response<ComponentPurgeResult> Purge(ComponentPurgeContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.Purge");
            scope.Start();
            try
            {
                var response = _applicationInsightsComponentComponentsRestClient.Purge(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get status for an ongoing purge operation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/operations/{purgeId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_GetPurgeStatus</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="purgeId"> In a purge status request, this is the Id of the operation the status of which is returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="purgeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="purgeId"/> is null. </exception>
        public virtual async Task<Response<ComponentPurgeStatusResult>> GetPurgeStatusAsync(string purgeId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(purgeId, nameof(purgeId));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetPurgeStatus");
            scope.Start();
            try
            {
                var response = await _applicationInsightsComponentComponentsRestClient.GetPurgeStatusAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, purgeId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get status for an ongoing purge operation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/operations/{purgeId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_GetPurgeStatus</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="purgeId"> In a purge status request, this is the Id of the operation the status of which is returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="purgeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="purgeId"/> is null. </exception>
        public virtual Response<ComponentPurgeStatusResult> GetPurgeStatus(string purgeId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(purgeId, nameof(purgeId));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetPurgeStatus");
            scope.Start();
            try
            {
                var response = _applicationInsightsComponentComponentsRestClient.GetPurgeStatus(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, purgeId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the list of annotations for a component for given time range
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Annotations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> The start time to query from for annotations, cannot be older than 90 days from current date. </param>
        /// <param name="end"> The end time to query for annotations. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="start"/> or <paramref name="end"/> is null. </exception>
        /// <returns> An async collection of <see cref="ApplicationInsightsAnnotation"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsAnnotation> GetAnnotationsAsync(string start, string end, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(start, nameof(start));
            Argument.AssertNotNull(end, nameof(end));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _annotationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, start, end);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ApplicationInsightsAnnotation.DeserializeApplicationInsightsAnnotation(e), _annotationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetAnnotations", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets the list of annotations for a component for given time range
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Annotations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> The start time to query from for annotations, cannot be older than 90 days from current date. </param>
        /// <param name="end"> The end time to query for annotations. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="start"/> or <paramref name="end"/> is null. </exception>
        /// <returns> A collection of <see cref="ApplicationInsightsAnnotation"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsAnnotation> GetAnnotations(string start, string end, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(start, nameof(start));
            Argument.AssertNotNull(end, nameof(end));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _annotationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, start, end);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ApplicationInsightsAnnotation.DeserializeApplicationInsightsAnnotation(e), _annotationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetAnnotations", "value", null, cancellationToken);
        }

        /// <summary>
        /// Create an Annotation of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Annotations_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="annotationProperties"> Properties that need to be specified to create an annotation of a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="annotationProperties"/> is null. </exception>
        /// <returns> An async collection of <see cref="ApplicationInsightsAnnotation"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsAnnotation> CreateAnnotationsAsync(ApplicationInsightsAnnotation annotationProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(annotationProperties, nameof(annotationProperties));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _annotationsRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, annotationProperties);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ApplicationInsightsAnnotation.DeserializeApplicationInsightsAnnotation(e), _annotationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.CreateAnnotations", "", null, cancellationToken);
        }

        /// <summary>
        /// Create an Annotation of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Annotations_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="annotationProperties"> Properties that need to be specified to create an annotation of a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="annotationProperties"/> is null. </exception>
        /// <returns> A collection of <see cref="ApplicationInsightsAnnotation"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsAnnotation> CreateAnnotations(ApplicationInsightsAnnotation annotationProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(annotationProperties, nameof(annotationProperties));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _annotationsRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, annotationProperties);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ApplicationInsightsAnnotation.DeserializeApplicationInsightsAnnotation(e), _annotationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.CreateAnnotations", "", null, cancellationToken);
        }

        /// <summary>
        /// Delete an Annotation of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations/{annotationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Annotations_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="annotationId"> The unique annotation ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="annotationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="annotationId"/> is null. </exception>
        public virtual async Task<Response> DeleteAnnotationAsync(string annotationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(annotationId, nameof(annotationId));

            using var scope = _annotationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteAnnotation");
            scope.Start();
            try
            {
                var response = await _annotationsRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, annotationId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete an Annotation of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations/{annotationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Annotations_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="annotationId"> The unique annotation ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="annotationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="annotationId"/> is null. </exception>
        public virtual Response DeleteAnnotation(string annotationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(annotationId, nameof(annotationId));

            using var scope = _annotationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteAnnotation");
            scope.Start();
            try
            {
                var response = _annotationsRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, annotationId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the annotation for given id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations/{annotationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Annotations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="annotationId"> The unique annotation ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="annotationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="annotationId"/> is null. </exception>
        /// <returns> An async collection of <see cref="ApplicationInsightsAnnotation"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsAnnotation> GetAnnotationsAsync(string annotationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(annotationId, nameof(annotationId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _annotationsRestClient.CreateGetRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, annotationId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ApplicationInsightsAnnotation.DeserializeApplicationInsightsAnnotation(e), _annotationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetAnnotations", "", null, cancellationToken);
        }

        /// <summary>
        /// Get the annotation for given id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations/{annotationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Annotations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="annotationId"> The unique annotation ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="annotationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="annotationId"/> is null. </exception>
        /// <returns> A collection of <see cref="ApplicationInsightsAnnotation"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsAnnotation> GetAnnotations(string annotationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(annotationId, nameof(annotationId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _annotationsRestClient.CreateGetRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, annotationId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ApplicationInsightsAnnotation.DeserializeApplicationInsightsAnnotation(e), _annotationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetAnnotations", "", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of API keys of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ApiKeys</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>APIKeys_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ApplicationInsightsComponentApiKey"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsComponentApiKey> GetApiKeysAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _apiKeysRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ApplicationInsightsComponentApiKey.DeserializeApplicationInsightsComponentApiKey(e), _apiKeysClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetApiKeys", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of API keys of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ApiKeys</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>APIKeys_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ApplicationInsightsComponentApiKey"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsComponentApiKey> GetApiKeys(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _apiKeysRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ApplicationInsightsComponentApiKey.DeserializeApplicationInsightsComponentApiKey(e), _apiKeysClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetApiKeys", "value", null, cancellationToken);
        }

        /// <summary>
        /// Create an API Key of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ApiKeys</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>APIKeys_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Properties that need to be specified to create an API key of a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentApiKey>> CreateApiKeyAsync(ApplicationInsightsApiKeyContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _apiKeysClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.CreateApiKey");
            scope.Start();
            try
            {
                var response = await _apiKeysRestClient.CreateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create an API Key of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ApiKeys</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>APIKeys_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Properties that need to be specified to create an API key of a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentApiKey> CreateApiKey(ApplicationInsightsApiKeyContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _apiKeysClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.CreateApiKey");
            scope.Start();
            try
            {
                var response = _apiKeysRestClient.Create(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete an API Key of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/APIKeys/{keyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>APIKeys_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="keyId"> The API Key ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="keyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="keyId"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentApiKey>> DeleteApiKeyAsync(string keyId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(keyId, nameof(keyId));

            using var scope = _apiKeysClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteApiKey");
            scope.Start();
            try
            {
                var response = await _apiKeysRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, keyId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete an API Key of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/APIKeys/{keyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>APIKeys_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="keyId"> The API Key ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="keyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="keyId"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentApiKey> DeleteApiKey(string keyId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(keyId, nameof(keyId));

            using var scope = _apiKeysClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteApiKey");
            scope.Start();
            try
            {
                var response = _apiKeysRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, keyId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the API Key for this key id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/APIKeys/{keyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>APIKeys_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="keyId"> The API Key ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="keyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="keyId"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentApiKey>> GetApiKeyAsync(string keyId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(keyId, nameof(keyId));

            using var scope = _apiKeysClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetApiKey");
            scope.Start();
            try
            {
                var response = await _apiKeysRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, keyId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the API Key for this key id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/APIKeys/{keyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>APIKeys_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="keyId"> The API Key ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="keyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="keyId"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentApiKey> GetApiKey(string keyId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(keyId, nameof(keyId));

            using var scope = _apiKeysClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetApiKey");
            scope.Start();
            try
            {
                var response = _apiKeysRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, keyId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of Continuous Export configuration of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExportConfigurations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ApplicationInsightsComponentExportConfiguration"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsComponentExportConfiguration> GetExportConfigurationsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _exportConfigurationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ApplicationInsightsComponentExportConfiguration.DeserializeApplicationInsightsComponentExportConfiguration(e), _exportConfigurationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetExportConfigurations", "", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of Continuous Export configuration of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExportConfigurations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ApplicationInsightsComponentExportConfiguration"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsComponentExportConfiguration> GetExportConfigurations(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _exportConfigurationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ApplicationInsightsComponentExportConfiguration.DeserializeApplicationInsightsComponentExportConfiguration(e), _exportConfigurationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetExportConfigurations", "", null, cancellationToken);
        }

        /// <summary>
        /// Create a Continuous Export configuration of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExportConfigurations_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Properties that need to be specified to create a Continuous Export configuration of a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <returns> An async collection of <see cref="ApplicationInsightsComponentExportConfiguration"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsComponentExportConfiguration> CreateExportConfigurationsAsync(ApplicationInsightsComponentExportContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _exportConfigurationsRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, content);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ApplicationInsightsComponentExportConfiguration.DeserializeApplicationInsightsComponentExportConfiguration(e), _exportConfigurationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.CreateExportConfigurations", "", null, cancellationToken);
        }

        /// <summary>
        /// Create a Continuous Export configuration of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExportConfigurations_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Properties that need to be specified to create a Continuous Export configuration of a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <returns> A collection of <see cref="ApplicationInsightsComponentExportConfiguration"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsComponentExportConfiguration> CreateExportConfigurations(ApplicationInsightsComponentExportContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _exportConfigurationsRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, content);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ApplicationInsightsComponentExportConfiguration.DeserializeApplicationInsightsComponentExportConfiguration(e), _exportConfigurationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.CreateExportConfigurations", "", null, cancellationToken);
        }

        /// <summary>
        /// Delete a Continuous Export configuration of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExportConfigurations_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="exportId"> The Continuous Export configuration ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="exportId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="exportId"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentExportConfiguration>> DeleteExportConfigurationAsync(string exportId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(exportId, nameof(exportId));

            using var scope = _exportConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteExportConfiguration");
            scope.Start();
            try
            {
                var response = await _exportConfigurationsRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, exportId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete a Continuous Export configuration of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExportConfigurations_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="exportId"> The Continuous Export configuration ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="exportId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="exportId"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentExportConfiguration> DeleteExportConfiguration(string exportId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(exportId, nameof(exportId));

            using var scope = _exportConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteExportConfiguration");
            scope.Start();
            try
            {
                var response = _exportConfigurationsRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, exportId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the Continuous Export configuration for this export id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExportConfigurations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="exportId"> The Continuous Export configuration ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="exportId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="exportId"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentExportConfiguration>> GetExportConfigurationAsync(string exportId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(exportId, nameof(exportId));

            using var scope = _exportConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetExportConfiguration");
            scope.Start();
            try
            {
                var response = await _exportConfigurationsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, exportId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the Continuous Export configuration for this export id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExportConfigurations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="exportId"> The Continuous Export configuration ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="exportId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="exportId"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentExportConfiguration> GetExportConfiguration(string exportId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(exportId, nameof(exportId));

            using var scope = _exportConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetExportConfiguration");
            scope.Start();
            try
            {
                var response = _exportConfigurationsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, exportId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update the Continuous Export configuration for this export id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExportConfigurations_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="exportId"> The Continuous Export configuration ID. This is unique within a Application Insights component. </param>
        /// <param name="content"> Properties that need to be specified to update the Continuous Export configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="exportId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="exportId"/> or <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentExportConfiguration>> UpdateExportConfigurationAsync(string exportId, ApplicationInsightsComponentExportContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(exportId, nameof(exportId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _exportConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.UpdateExportConfiguration");
            scope.Start();
            try
            {
                var response = await _exportConfigurationsRestClient.UpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, exportId, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update the Continuous Export configuration for this export id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExportConfigurations_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="exportId"> The Continuous Export configuration ID. This is unique within a Application Insights component. </param>
        /// <param name="content"> Properties that need to be specified to update the Continuous Export configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="exportId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="exportId"/> or <paramref name="content"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentExportConfiguration> UpdateExportConfiguration(string exportId, ApplicationInsightsComponentExportContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(exportId, nameof(exportId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _exportConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.UpdateExportConfiguration");
            scope.Start();
            try
            {
                var response = _exportConfigurationsRestClient.Update(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, exportId, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns current billing features for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/currentbillingfeatures</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComponentCurrentBillingFeatures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ApplicationInsightsComponentBillingFeatures>> GetComponentCurrentBillingFeatureAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _componentCurrentBillingFeaturesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetComponentCurrentBillingFeature");
            scope.Start();
            try
            {
                var response = await _componentCurrentBillingFeaturesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns current billing features for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/currentbillingfeatures</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComponentCurrentBillingFeatures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ApplicationInsightsComponentBillingFeatures> GetComponentCurrentBillingFeature(CancellationToken cancellationToken = default)
        {
            using var scope = _componentCurrentBillingFeaturesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetComponentCurrentBillingFeature");
            scope.Start();
            try
            {
                var response = _componentCurrentBillingFeaturesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update current billing features for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/currentbillingfeatures</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComponentCurrentBillingFeatures_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingFeaturesProperties"> Properties that need to be specified to update billing features for an Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="billingFeaturesProperties"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentBillingFeatures>> UpdateComponentCurrentBillingFeatureAsync(ApplicationInsightsComponentBillingFeatures billingFeaturesProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(billingFeaturesProperties, nameof(billingFeaturesProperties));

            using var scope = _componentCurrentBillingFeaturesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.UpdateComponentCurrentBillingFeature");
            scope.Start();
            try
            {
                var response = await _componentCurrentBillingFeaturesRestClient.UpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, billingFeaturesProperties, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update current billing features for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/currentbillingfeatures</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComponentCurrentBillingFeatures_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingFeaturesProperties"> Properties that need to be specified to update billing features for an Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="billingFeaturesProperties"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentBillingFeatures> UpdateComponentCurrentBillingFeature(ApplicationInsightsComponentBillingFeatures billingFeaturesProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(billingFeaturesProperties, nameof(billingFeaturesProperties));

            using var scope = _componentCurrentBillingFeaturesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.UpdateComponentCurrentBillingFeature");
            scope.Start();
            try
            {
                var response = _componentCurrentBillingFeaturesRestClient.Update(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, billingFeaturesProperties, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns daily data volume cap (quota) status for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/quotastatus</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComponentQuotaStatus_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ApplicationInsightsComponentQuotaStatus>> GetComponentQuotaStatusAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _componentQuotaStatusClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetComponentQuotaStatus");
            scope.Start();
            try
            {
                var response = await _componentQuotaStatusRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns daily data volume cap (quota) status for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/quotastatus</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComponentQuotaStatus_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ApplicationInsightsComponentQuotaStatus> GetComponentQuotaStatus(CancellationToken cancellationToken = default)
        {
            using var scope = _componentQuotaStatusClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetComponentQuotaStatus");
            scope.Start();
            try
            {
                var response = _componentQuotaStatusRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns feature capabilities of the application insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/featurecapabilities</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComponentFeatureCapabilities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ApplicationInsightsComponentFeatureCapabilities>> GetComponentFeatureCapabilityAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _componentFeatureCapabilitiesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetComponentFeatureCapability");
            scope.Start();
            try
            {
                var response = await _componentFeatureCapabilitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns feature capabilities of the application insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/featurecapabilities</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComponentFeatureCapabilities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ApplicationInsightsComponentFeatureCapabilities> GetComponentFeatureCapability(CancellationToken cancellationToken = default)
        {
            using var scope = _componentFeatureCapabilitiesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetComponentFeatureCapability");
            scope.Start();
            try
            {
                var response = _componentFeatureCapabilitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns all available features of the application insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/getavailablebillingfeatures</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComponentAvailableFeatures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ApplicationInsightsComponentAvailableFeatures>> GetComponentAvailableFeatureAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _componentAvailableFeaturesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetComponentAvailableFeature");
            scope.Start();
            try
            {
                var response = await _componentAvailableFeaturesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns all available features of the application insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/getavailablebillingfeatures</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComponentAvailableFeatures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ApplicationInsightsComponentAvailableFeatures> GetComponentAvailableFeature(CancellationToken cancellationToken = default)
        {
            using var scope = _componentAvailableFeaturesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetComponentAvailableFeature");
            scope.Start();
            try
            {
                var response = _componentAvailableFeaturesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of ProactiveDetection configurations of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProactiveDetectionConfigurations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ApplicationInsightsComponentProactiveDetectionConfiguration"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsComponentProactiveDetectionConfiguration> GetProactiveDetectionConfigurationsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _proactiveDetectionConfigurationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ApplicationInsightsComponentProactiveDetectionConfiguration.DeserializeApplicationInsightsComponentProactiveDetectionConfiguration(e), _proactiveDetectionConfigurationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetProactiveDetectionConfigurations", "", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of ProactiveDetection configurations of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProactiveDetectionConfigurations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ApplicationInsightsComponentProactiveDetectionConfiguration"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsComponentProactiveDetectionConfiguration> GetProactiveDetectionConfigurations(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _proactiveDetectionConfigurationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ApplicationInsightsComponentProactiveDetectionConfiguration.DeserializeApplicationInsightsComponentProactiveDetectionConfiguration(e), _proactiveDetectionConfigurationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetProactiveDetectionConfigurations", "", null, cancellationToken);
        }

        /// <summary>
        /// Get the ProactiveDetection configuration for this configuration id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProactiveDetectionConfigurations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationId"> The ProactiveDetection configuration ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationId"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentProactiveDetectionConfiguration>> GetProactiveDetectionConfigurationAsync(string configurationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationId, nameof(configurationId));

            using var scope = _proactiveDetectionConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetProactiveDetectionConfiguration");
            scope.Start();
            try
            {
                var response = await _proactiveDetectionConfigurationsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the ProactiveDetection configuration for this configuration id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProactiveDetectionConfigurations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationId"> The ProactiveDetection configuration ID. This is unique within a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationId"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentProactiveDetectionConfiguration> GetProactiveDetectionConfiguration(string configurationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationId, nameof(configurationId));

            using var scope = _proactiveDetectionConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetProactiveDetectionConfiguration");
            scope.Start();
            try
            {
                var response = _proactiveDetectionConfigurationsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update the ProactiveDetection configuration for this configuration id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProactiveDetectionConfigurations_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationId"> The ProactiveDetection configuration ID. This is unique within a Application Insights component. </param>
        /// <param name="proactiveDetectionProperties"> Properties that need to be specified to update the ProactiveDetection configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationId"/> or <paramref name="proactiveDetectionProperties"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentProactiveDetectionConfiguration>> UpdateProactiveDetectionConfigurationAsync(string configurationId, ApplicationInsightsComponentProactiveDetectionConfiguration proactiveDetectionProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationId, nameof(configurationId));
            Argument.AssertNotNull(proactiveDetectionProperties, nameof(proactiveDetectionProperties));

            using var scope = _proactiveDetectionConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.UpdateProactiveDetectionConfiguration");
            scope.Start();
            try
            {
                var response = await _proactiveDetectionConfigurationsRestClient.UpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationId, proactiveDetectionProperties, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update the ProactiveDetection configuration for this configuration id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProactiveDetectionConfigurations_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationId"> The ProactiveDetection configuration ID. This is unique within a Application Insights component. </param>
        /// <param name="proactiveDetectionProperties"> Properties that need to be specified to update the ProactiveDetection configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationId"/> or <paramref name="proactiveDetectionProperties"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentProactiveDetectionConfiguration> UpdateProactiveDetectionConfiguration(string configurationId, ApplicationInsightsComponentProactiveDetectionConfiguration proactiveDetectionProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationId, nameof(configurationId));
            Argument.AssertNotNull(proactiveDetectionProperties, nameof(proactiveDetectionProperties));

            using var scope = _proactiveDetectionConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.UpdateProactiveDetectionConfiguration");
            scope.Start();
            try
            {
                var response = _proactiveDetectionConfigurationsRestClient.Update(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationId, proactiveDetectionProperties, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the list work item configurations that exist for the application
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="WorkItemConfiguration"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<WorkItemConfiguration> GetWorkItemConfigurationsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _workItemConfigurationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => WorkItemConfiguration.DeserializeWorkItemConfiguration(e), _workItemConfigurationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetWorkItemConfigurations", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets the list work item configurations that exist for the application
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="WorkItemConfiguration"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<WorkItemConfiguration> GetWorkItemConfigurations(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _workItemConfigurationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => WorkItemConfiguration.DeserializeWorkItemConfiguration(e), _workItemConfigurationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetWorkItemConfigurations", "value", null, cancellationToken);
        }

        /// <summary>
        /// Create a work item configuration for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workItemConfigurationProperties"> Properties that need to be specified to create a work item configuration of a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="workItemConfigurationProperties"/> is null. </exception>
        public virtual async Task<Response<WorkItemConfiguration>> CreateWorkItemConfigurationAsync(WorkItemCreateConfiguration workItemConfigurationProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(workItemConfigurationProperties, nameof(workItemConfigurationProperties));

            using var scope = _workItemConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.CreateWorkItemConfiguration");
            scope.Start();
            try
            {
                var response = await _workItemConfigurationsRestClient.CreateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workItemConfigurationProperties, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a work item configuration for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workItemConfigurationProperties"> Properties that need to be specified to create a work item configuration of a Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="workItemConfigurationProperties"/> is null. </exception>
        public virtual Response<WorkItemConfiguration> CreateWorkItemConfiguration(WorkItemCreateConfiguration workItemConfigurationProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(workItemConfigurationProperties, nameof(workItemConfigurationProperties));

            using var scope = _workItemConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.CreateWorkItemConfiguration");
            scope.Start();
            try
            {
                var response = _workItemConfigurationsRestClient.Create(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workItemConfigurationProperties, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets default work item configurations that exist for the application
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/DefaultWorkItemConfig</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_GetDefault</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<WorkItemConfiguration>> GetDefaultWorkItemConfigurationAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _workItemConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetDefaultWorkItemConfiguration");
            scope.Start();
            try
            {
                var response = await _workItemConfigurationsRestClient.GetDefaultAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets default work item configurations that exist for the application
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/DefaultWorkItemConfig</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_GetDefault</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<WorkItemConfiguration> GetDefaultWorkItemConfiguration(CancellationToken cancellationToken = default)
        {
            using var scope = _workItemConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetDefaultWorkItemConfiguration");
            scope.Start();
            try
            {
                var response = _workItemConfigurationsRestClient.GetDefault(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete a work item configuration of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workItemConfigId"> The unique work item configuration Id. This can be either friendly name of connector as defined in connector configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workItemConfigId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workItemConfigId"/> is null. </exception>
        public virtual async Task<Response> DeleteWorkItemConfigurationAsync(string workItemConfigId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workItemConfigId, nameof(workItemConfigId));

            using var scope = _workItemConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteWorkItemConfiguration");
            scope.Start();
            try
            {
                var response = await _workItemConfigurationsRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workItemConfigId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete a work item configuration of an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workItemConfigId"> The unique work item configuration Id. This can be either friendly name of connector as defined in connector configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workItemConfigId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workItemConfigId"/> is null. </exception>
        public virtual Response DeleteWorkItemConfiguration(string workItemConfigId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workItemConfigId, nameof(workItemConfigId));

            using var scope = _workItemConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteWorkItemConfiguration");
            scope.Start();
            try
            {
                var response = _workItemConfigurationsRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workItemConfigId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets specified work item configuration for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_GetItem</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workItemConfigId"> The unique work item configuration Id. This can be either friendly name of connector as defined in connector configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workItemConfigId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workItemConfigId"/> is null. </exception>
        public virtual async Task<Response<WorkItemConfiguration>> GetItemWorkItemConfigurationAsync(string workItemConfigId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workItemConfigId, nameof(workItemConfigId));

            using var scope = _workItemConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetItemWorkItemConfiguration");
            scope.Start();
            try
            {
                var response = await _workItemConfigurationsRestClient.GetItemAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workItemConfigId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets specified work item configuration for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_GetItem</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workItemConfigId"> The unique work item configuration Id. This can be either friendly name of connector as defined in connector configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workItemConfigId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workItemConfigId"/> is null. </exception>
        public virtual Response<WorkItemConfiguration> GetItemWorkItemConfiguration(string workItemConfigId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workItemConfigId, nameof(workItemConfigId));

            using var scope = _workItemConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetItemWorkItemConfiguration");
            scope.Start();
            try
            {
                var response = _workItemConfigurationsRestClient.GetItem(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workItemConfigId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update a work item configuration for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_UpdateItem</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workItemConfigId"> The unique work item configuration Id. This can be either friendly name of connector as defined in connector configuration. </param>
        /// <param name="workItemConfigurationProperties"> Properties that need to be specified to update a work item configuration for this Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workItemConfigId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workItemConfigId"/> or <paramref name="workItemConfigurationProperties"/> is null. </exception>
        public virtual async Task<Response<WorkItemConfiguration>> UpdateItemWorkItemConfigurationAsync(string workItemConfigId, WorkItemCreateConfiguration workItemConfigurationProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workItemConfigId, nameof(workItemConfigId));
            Argument.AssertNotNull(workItemConfigurationProperties, nameof(workItemConfigurationProperties));

            using var scope = _workItemConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.UpdateItemWorkItemConfiguration");
            scope.Start();
            try
            {
                var response = await _workItemConfigurationsRestClient.UpdateItemAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workItemConfigId, workItemConfigurationProperties, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update a work item configuration for an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkItemConfigurations_UpdateItem</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workItemConfigId"> The unique work item configuration Id. This can be either friendly name of connector as defined in connector configuration. </param>
        /// <param name="workItemConfigurationProperties"> Properties that need to be specified to update a work item configuration for this Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workItemConfigId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workItemConfigId"/> or <paramref name="workItemConfigurationProperties"/> is null. </exception>
        public virtual Response<WorkItemConfiguration> UpdateItemWorkItemConfiguration(string workItemConfigId, WorkItemCreateConfiguration workItemConfigurationProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workItemConfigId, nameof(workItemConfigId));
            Argument.AssertNotNull(workItemConfigurationProperties, nameof(workItemConfigurationProperties));

            using var scope = _workItemConfigurationsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.UpdateItemWorkItemConfiguration");
            scope.Start();
            try
            {
                var response = _workItemConfigurationsRestClient.UpdateItem(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workItemConfigId, workItemConfigurationProperties, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of favorites defined within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Favorites_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="favoriteType"> The type of favorite. Value can be either shared or user. </param>
        /// <param name="sourceType"> Source type of favorite to return. When left out, the source type defaults to 'other' (not present in this enum). </param>
        /// <param name="canFetchContent"> Flag indicating whether or not to return the full content for each applicable favorite. If false, only return summary content for favorites. </param>
        /// <param name="tags"> Tags that must be present on each favorite returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ApplicationInsightsComponentFavorite"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsComponentFavorite> GetFavoritesAsync(ComponentFavoriteType? favoriteType = null, FavoriteSourceType? sourceType = null, bool? canFetchContent = null, IEnumerable<string> tags = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _favoritesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, favoriteType, sourceType, canFetchContent, tags);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ApplicationInsightsComponentFavorite.DeserializeApplicationInsightsComponentFavorite(e), _favoritesClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetFavorites", "", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of favorites defined within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Favorites_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="favoriteType"> The type of favorite. Value can be either shared or user. </param>
        /// <param name="sourceType"> Source type of favorite to return. When left out, the source type defaults to 'other' (not present in this enum). </param>
        /// <param name="canFetchContent"> Flag indicating whether or not to return the full content for each applicable favorite. If false, only return summary content for favorites. </param>
        /// <param name="tags"> Tags that must be present on each favorite returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ApplicationInsightsComponentFavorite"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsComponentFavorite> GetFavorites(ComponentFavoriteType? favoriteType = null, FavoriteSourceType? sourceType = null, bool? canFetchContent = null, IEnumerable<string> tags = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _favoritesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, favoriteType, sourceType, canFetchContent, tags);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ApplicationInsightsComponentFavorite.DeserializeApplicationInsightsComponentFavorite(e), _favoritesClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetFavorites", "", null, cancellationToken);
        }

        /// <summary>
        /// Get a single favorite by its FavoriteId, defined within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Favorites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="favoriteId"> The Id of a specific favorite defined in the Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="favoriteId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="favoriteId"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentFavorite>> GetFavoriteAsync(string favoriteId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(favoriteId, nameof(favoriteId));

            using var scope = _favoritesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetFavorite");
            scope.Start();
            try
            {
                var response = await _favoritesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, favoriteId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a single favorite by its FavoriteId, defined within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Favorites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="favoriteId"> The Id of a specific favorite defined in the Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="favoriteId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="favoriteId"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentFavorite> GetFavorite(string favoriteId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(favoriteId, nameof(favoriteId));

            using var scope = _favoritesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetFavorite");
            scope.Start();
            try
            {
                var response = _favoritesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, favoriteId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Adds a new favorites to an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Favorites_Add</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="favoriteId"> The Id of a specific favorite defined in the Application Insights component. </param>
        /// <param name="favoriteProperties"> Properties that need to be specified to create a new favorite and add it to an Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="favoriteId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="favoriteId"/> or <paramref name="favoriteProperties"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentFavorite>> AddFavoriteAsync(string favoriteId, ApplicationInsightsComponentFavorite favoriteProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(favoriteId, nameof(favoriteId));
            Argument.AssertNotNull(favoriteProperties, nameof(favoriteProperties));

            using var scope = _favoritesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.AddFavorite");
            scope.Start();
            try
            {
                var response = await _favoritesRestClient.AddAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, favoriteId, favoriteProperties, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Adds a new favorites to an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Favorites_Add</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="favoriteId"> The Id of a specific favorite defined in the Application Insights component. </param>
        /// <param name="favoriteProperties"> Properties that need to be specified to create a new favorite and add it to an Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="favoriteId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="favoriteId"/> or <paramref name="favoriteProperties"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentFavorite> AddFavorite(string favoriteId, ApplicationInsightsComponentFavorite favoriteProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(favoriteId, nameof(favoriteId));
            Argument.AssertNotNull(favoriteProperties, nameof(favoriteProperties));

            using var scope = _favoritesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.AddFavorite");
            scope.Start();
            try
            {
                var response = _favoritesRestClient.Add(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, favoriteId, favoriteProperties, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates a favorite that has already been added to an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Favorites_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="favoriteId"> The Id of a specific favorite defined in the Application Insights component. </param>
        /// <param name="favoriteProperties"> Properties that need to be specified to update the existing favorite. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="favoriteId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="favoriteId"/> or <paramref name="favoriteProperties"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentFavorite>> UpdateFavoriteAsync(string favoriteId, ApplicationInsightsComponentFavorite favoriteProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(favoriteId, nameof(favoriteId));
            Argument.AssertNotNull(favoriteProperties, nameof(favoriteProperties));

            using var scope = _favoritesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.UpdateFavorite");
            scope.Start();
            try
            {
                var response = await _favoritesRestClient.UpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, favoriteId, favoriteProperties, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates a favorite that has already been added to an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Favorites_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="favoriteId"> The Id of a specific favorite defined in the Application Insights component. </param>
        /// <param name="favoriteProperties"> Properties that need to be specified to update the existing favorite. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="favoriteId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="favoriteId"/> or <paramref name="favoriteProperties"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentFavorite> UpdateFavorite(string favoriteId, ApplicationInsightsComponentFavorite favoriteProperties, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(favoriteId, nameof(favoriteId));
            Argument.AssertNotNull(favoriteProperties, nameof(favoriteProperties));

            using var scope = _favoritesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.UpdateFavorite");
            scope.Start();
            try
            {
                var response = _favoritesRestClient.Update(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, favoriteId, favoriteProperties, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Remove a favorite that is associated to an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Favorites_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="favoriteId"> The Id of a specific favorite defined in the Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="favoriteId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="favoriteId"/> is null. </exception>
        public virtual async Task<Response> DeleteFavoriteAsync(string favoriteId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(favoriteId, nameof(favoriteId));

            using var scope = _favoritesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteFavorite");
            scope.Start();
            try
            {
                var response = await _favoritesRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, favoriteId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Remove a favorite that is associated to an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Favorites_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="favoriteId"> The Id of a specific favorite defined in the Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="favoriteId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="favoriteId"/> is null. </exception>
        public virtual Response DeleteFavorite(string favoriteId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(favoriteId, nameof(favoriteId));

            using var scope = _favoritesClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteFavorite");
            scope.Start();
            try
            {
                var response = _favoritesRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, favoriteId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of web test locations available to this Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/syntheticmonitorlocations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>webTestLocations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ApplicationInsightsComponentWebTestLocation"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsComponentWebTestLocation> GetWebTestLocationsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _webTestLocationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ApplicationInsightsComponentWebTestLocation.DeserializeApplicationInsightsComponentWebTestLocation(e), _webTestLocationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetWebTestLocations", "", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of web test locations available to this Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/syntheticmonitorlocations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>webTestLocations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ApplicationInsightsComponentWebTestLocation"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsComponentWebTestLocation> GetWebTestLocations(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _webTestLocationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ApplicationInsightsComponentWebTestLocation.DeserializeApplicationInsightsComponentWebTestLocation(e), _webTestLocationsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetWebTestLocations", "", null, cancellationToken);
        }

        /// <summary>
        /// Get all Application Insights web tests defined for the specified component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{componentName}/webtests</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_ListByComponent</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ApplicationInsightsWebTestResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsWebTestResource> GetWebTestsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _applicationInsightsWebTestWebTestsRestClient.CreateListByComponentRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _applicationInsightsWebTestWebTestsRestClient.CreateListByComponentNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ApplicationInsightsWebTestResource(Client, ApplicationInsightsWebTestData.DeserializeApplicationInsightsWebTestData(e)), _applicationInsightsWebTestWebTestsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetWebTests", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Get all Application Insights web tests defined for the specified component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{componentName}/webtests</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WebTests_ListByComponent</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-06-15</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsWebTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ApplicationInsightsWebTestResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsWebTestResource> GetWebTests(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _applicationInsightsWebTestWebTestsRestClient.CreateListByComponentRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _applicationInsightsWebTestWebTestsRestClient.CreateListByComponentNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ApplicationInsightsWebTestResource(Client, ApplicationInsightsWebTestData.DeserializeApplicationInsightsWebTestData(e)), _applicationInsightsWebTestWebTestsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetWebTests", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a list of Analytics Items defined within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AnalyticsItems_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopePath"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="scope"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="type"> Enum indicating the type of the Analytics item. </param>
        /// <param name="includeContent"> Flag indicating whether or not to return the content of each applicable item. If false, only return the item information. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ApplicationInsightsComponentAnalyticsItem"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApplicationInsightsComponentAnalyticsItem> GetAnalyticsItemsAsync(AnalyticsItemScopePath scopePath, ComponentItemScope? scope = null, AnalyticsItemTypeContent? type = null, bool? includeContent = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _analyticsItemsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, scopePath, scope, type, includeContent);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ApplicationInsightsComponentAnalyticsItem.DeserializeApplicationInsightsComponentAnalyticsItem(e), _analyticsItemsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetAnalyticsItems", "", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of Analytics Items defined within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AnalyticsItems_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopePath"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="scope"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="type"> Enum indicating the type of the Analytics item. </param>
        /// <param name="includeContent"> Flag indicating whether or not to return the content of each applicable item. If false, only return the item information. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ApplicationInsightsComponentAnalyticsItem"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApplicationInsightsComponentAnalyticsItem> GetAnalyticsItems(AnalyticsItemScopePath scopePath, ComponentItemScope? scope = null, AnalyticsItemTypeContent? type = null, bool? includeContent = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _analyticsItemsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, scopePath, scope, type, includeContent);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ApplicationInsightsComponentAnalyticsItem.DeserializeApplicationInsightsComponentAnalyticsItem(e), _analyticsItemsClientDiagnostics, Pipeline, "ApplicationInsightsComponentResource.GetAnalyticsItems", "", null, cancellationToken);
        }

        /// <summary>
        /// Gets a specific Analytics Items defined within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AnalyticsItems_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopePath"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="id"> The Id of a specific item defined in the Application Insights component. </param>
        /// <param name="name"> The name of a specific item defined in the Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ApplicationInsightsComponentAnalyticsItem>> GetAnalyticsItemAsync(AnalyticsItemScopePath scopePath, string id = null, string name = null, CancellationToken cancellationToken = default)
        {
            using var scope = _analyticsItemsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetAnalyticsItem");
            scope.Start();
            try
            {
                var response = await _analyticsItemsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, scopePath, id, name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a specific Analytics Items defined within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AnalyticsItems_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopePath"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="id"> The Id of a specific item defined in the Application Insights component. </param>
        /// <param name="name"> The name of a specific item defined in the Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ApplicationInsightsComponentAnalyticsItem> GetAnalyticsItem(AnalyticsItemScopePath scopePath, string id = null, string name = null, CancellationToken cancellationToken = default)
        {
            using var scope = _analyticsItemsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.GetAnalyticsItem");
            scope.Start();
            try
            {
                var response = _analyticsItemsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, scopePath, id, name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Adds or Updates a specific Analytics Item within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AnalyticsItems_Put</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopePath"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="itemProperties"> Properties that need to be specified to create a new item and add it to an Application Insights component. </param>
        /// <param name="overrideItem"> Flag indicating whether or not to force save an item. This allows overriding an item if it already exists. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="itemProperties"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentAnalyticsItem>> AddOrUpdateAnalyticsItemAsync(AnalyticsItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItem itemProperties, bool? overrideItem = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(itemProperties, nameof(itemProperties));

            using var scope = _analyticsItemsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.AddOrUpdateAnalyticsItem");
            scope.Start();
            try
            {
                var response = await _analyticsItemsRestClient.PutAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, scopePath, itemProperties, overrideItem, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Adds or Updates a specific Analytics Item within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AnalyticsItems_Put</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopePath"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="itemProperties"> Properties that need to be specified to create a new item and add it to an Application Insights component. </param>
        /// <param name="overrideItem"> Flag indicating whether or not to force save an item. This allows overriding an item if it already exists. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="itemProperties"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentAnalyticsItem> AddOrUpdateAnalyticsItem(AnalyticsItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItem itemProperties, bool? overrideItem = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(itemProperties, nameof(itemProperties));

            using var scope = _analyticsItemsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.AddOrUpdateAnalyticsItem");
            scope.Start();
            try
            {
                var response = _analyticsItemsRestClient.Put(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, scopePath, itemProperties, overrideItem, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes a specific Analytics Items defined within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AnalyticsItems_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopePath"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="id"> The Id of a specific item defined in the Application Insights component. </param>
        /// <param name="name"> The name of a specific item defined in the Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> DeleteAnalyticsItemAsync(AnalyticsItemScopePath scopePath, string id = null, string name = null, CancellationToken cancellationToken = default)
        {
            using var scope = _analyticsItemsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteAnalyticsItem");
            scope.Start();
            try
            {
                var response = await _analyticsItemsRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, scopePath, id, name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes a specific Analytics Items defined within an Application Insights component.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AnalyticsItems_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2015-05-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopePath"> Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. </param>
        /// <param name="id"> The Id of a specific item defined in the Application Insights component. </param>
        /// <param name="name"> The name of a specific item defined in the Application Insights component. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response DeleteAnalyticsItem(AnalyticsItemScopePath scopePath, string id = null, string name = null, CancellationToken cancellationToken = default)
        {
            using var scope = _analyticsItemsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.DeleteAnalyticsItem");
            scope.Start();
            try
            {
                var response = _analyticsItemsRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, scopePath, id, name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Add a tag to the current resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="value"> The value for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> or <paramref name="value"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentResource>> AddTagAsync(string key, string value, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));
            Argument.AssertNotNull(value, nameof(value));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.AddTag");
            scope.Start();
            try
            {
                if (await CanUseTagResourceAsync(cancellationToken: cancellationToken).ConfigureAwait(false))
                {
                    var originalTags = await GetTagResource().GetAsync(cancellationToken).ConfigureAwait(false);
                    originalTags.Value.Data.TagValues[key] = value;
                    await GetTagResource().CreateOrUpdateAsync(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalResponse = await _applicationInsightsComponentComponentsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                    return Response.FromValue(new ApplicationInsightsComponentResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = (await GetAsync(cancellationToken: cancellationToken).ConfigureAwait(false)).Value.Data;
                    var patch = new WebTestComponentTag();
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags[key] = value;
                    var result = await UpdateAsync(patch, cancellationToken: cancellationToken).ConfigureAwait(false);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Add a tag to the current resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="value"> The value for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> or <paramref name="value"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentResource> AddTag(string key, string value, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));
            Argument.AssertNotNull(value, nameof(value));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.AddTag");
            scope.Start();
            try
            {
                if (CanUseTagResource(cancellationToken: cancellationToken))
                {
                    var originalTags = GetTagResource().Get(cancellationToken);
                    originalTags.Value.Data.TagValues[key] = value;
                    GetTagResource().CreateOrUpdate(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken);
                    var originalResponse = _applicationInsightsComponentComponentsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                    return Response.FromValue(new ApplicationInsightsComponentResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = Get(cancellationToken: cancellationToken).Value.Data;
                    var patch = new WebTestComponentTag();
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags[key] = value;
                    var result = Update(patch, cancellationToken: cancellationToken);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Replace the tags on the resource with the given set.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="tags"> The set of tags to use as replacement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="tags"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentResource>> SetTagsAsync(IDictionary<string, string> tags, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(tags, nameof(tags));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.SetTags");
            scope.Start();
            try
            {
                if (await CanUseTagResourceAsync(cancellationToken: cancellationToken).ConfigureAwait(false))
                {
                    await GetTagResource().DeleteAsync(WaitUntil.Completed, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalTags = await GetTagResource().GetAsync(cancellationToken).ConfigureAwait(false);
                    originalTags.Value.Data.TagValues.ReplaceWith(tags);
                    await GetTagResource().CreateOrUpdateAsync(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalResponse = await _applicationInsightsComponentComponentsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                    return Response.FromValue(new ApplicationInsightsComponentResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = (await GetAsync(cancellationToken: cancellationToken).ConfigureAwait(false)).Value.Data;
                    var patch = new WebTestComponentTag();
                    patch.Tags.ReplaceWith(tags);
                    var result = await UpdateAsync(patch, cancellationToken: cancellationToken).ConfigureAwait(false);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Replace the tags on the resource with the given set.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="tags"> The set of tags to use as replacement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="tags"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentResource> SetTags(IDictionary<string, string> tags, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(tags, nameof(tags));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.SetTags");
            scope.Start();
            try
            {
                if (CanUseTagResource(cancellationToken: cancellationToken))
                {
                    GetTagResource().Delete(WaitUntil.Completed, cancellationToken: cancellationToken);
                    var originalTags = GetTagResource().Get(cancellationToken);
                    originalTags.Value.Data.TagValues.ReplaceWith(tags);
                    GetTagResource().CreateOrUpdate(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken);
                    var originalResponse = _applicationInsightsComponentComponentsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                    return Response.FromValue(new ApplicationInsightsComponentResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = Get(cancellationToken: cancellationToken).Value.Data;
                    var patch = new WebTestComponentTag();
                    patch.Tags.ReplaceWith(tags);
                    var result = Update(patch, cancellationToken: cancellationToken);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes a tag by key from the resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> is null. </exception>
        public virtual async Task<Response<ApplicationInsightsComponentResource>> RemoveTagAsync(string key, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.RemoveTag");
            scope.Start();
            try
            {
                if (await CanUseTagResourceAsync(cancellationToken: cancellationToken).ConfigureAwait(false))
                {
                    var originalTags = await GetTagResource().GetAsync(cancellationToken).ConfigureAwait(false);
                    originalTags.Value.Data.TagValues.Remove(key);
                    await GetTagResource().CreateOrUpdateAsync(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalResponse = await _applicationInsightsComponentComponentsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                    return Response.FromValue(new ApplicationInsightsComponentResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = (await GetAsync(cancellationToken: cancellationToken).ConfigureAwait(false)).Value.Data;
                    var patch = new WebTestComponentTag();
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags.Remove(key);
                    var result = await UpdateAsync(patch, cancellationToken: cancellationToken).ConfigureAwait(false);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes a tag by key from the resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Components_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-02-02</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApplicationInsightsComponentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> is null. </exception>
        public virtual Response<ApplicationInsightsComponentResource> RemoveTag(string key, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));

            using var scope = _applicationInsightsComponentComponentsClientDiagnostics.CreateScope("ApplicationInsightsComponentResource.RemoveTag");
            scope.Start();
            try
            {
                if (CanUseTagResource(cancellationToken: cancellationToken))
                {
                    var originalTags = GetTagResource().Get(cancellationToken);
                    originalTags.Value.Data.TagValues.Remove(key);
                    GetTagResource().CreateOrUpdate(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken);
                    var originalResponse = _applicationInsightsComponentComponentsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                    return Response.FromValue(new ApplicationInsightsComponentResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = Get(cancellationToken: cancellationToken).Value.Data;
                    var patch = new WebTestComponentTag();
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags.Remove(key);
                    var result = Update(patch, cancellationToken: cancellationToken);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
