// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ApplicationInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApplicationInsights
{
    /// <summary>
    /// A class representing the ApplicationInsightsComponent data model.
    /// An Application Insights component definition.
    /// </summary>
    public partial class ApplicationInsightsComponentData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsComponentData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> The kind of application that this component refers to, used to customize UI. This value is a freeform string, values should typically be one of the following: web, ios, other, store, java, phone. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kind"/> is null. </exception>
        public ApplicationInsightsComponentData(AzureLocation location, string kind) : base(location)
        {
            Argument.AssertNotNull(kind, nameof(kind));

            Kind = kind;
            PrivateLinkScopedResources = new ChangeTrackingList<PrivateLinkScopedResourceReference>();
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsComponentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> The kind of application that this component refers to, used to customize UI. This value is a freeform string, values should typically be one of the following: web, ios, other, store, java, phone. </param>
        /// <param name="etag"> Resource etag. </param>
        /// <param name="applicationId"> The unique ID of your application. This field mirrors the 'Name' field and cannot be changed. </param>
        /// <param name="appId"> Application Insights Unique ID for your Application. </param>
        /// <param name="namePropertiesName"> Application name. </param>
        /// <param name="applicationType"> Type of application being monitored. </param>
        /// <param name="flowType"> Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API. </param>
        /// <param name="requestSource"> Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'. </param>
        /// <param name="instrumentationKey"> Application Insights Instrumentation key. A read-only value that applications can use to identify the destination for all telemetry sent to Azure Application Insights. This value will be supplied upon construction of each new Application Insights component. </param>
        /// <param name="createdOn"> Creation Date for the Application Insights component, in ISO 8601 format. </param>
        /// <param name="tenantId"> Azure Tenant Id. </param>
        /// <param name="hockeyAppId"> The unique application ID created when a new application is added to HockeyApp, used for communications with HockeyApp. </param>
        /// <param name="hockeyAppToken"> Token used to authenticate communications with between Application Insights and HockeyApp. </param>
        /// <param name="provisioningState"> Current state of this component: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed. </param>
        /// <param name="samplingPercentage"> Percentage of the data produced by the application being monitored that is being sampled for Application Insights telemetry. </param>
        /// <param name="connectionString"> Application Insights component connection string. </param>
        /// <param name="retentionInDays"> Retention period in days. </param>
        /// <param name="isDisableIPMasking"> Disable IP masking. </param>
        /// <param name="isImmediatePurgeDataOn30Days"> Purge data immediately after 30 days. </param>
        /// <param name="workspaceResourceId"> Resource Id of the log analytics workspace which the data will be ingested to. This property is required to create an application with this API version. Applications from older versions will not have this property. </param>
        /// <param name="laMigrationOn"> The date which the component got migrated to LA, in ISO 8601 format. </param>
        /// <param name="privateLinkScopedResources"> List of linked private link scope resources. </param>
        /// <param name="publicNetworkAccessForIngestion"> The network access type for accessing Application Insights ingestion. </param>
        /// <param name="publicNetworkAccessForQuery"> The network access type for accessing Application Insights query. </param>
        /// <param name="ingestionMode"> Indicates the flow of the ingestion. </param>
        /// <param name="isDisableLocalAuth"> Disable Non-AAD based Auth. </param>
        /// <param name="isForceCustomerStorageForProfiler"> Force users to create their own storage account for profiler and debugger. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplicationInsightsComponentData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, string kind, ETag? etag, string applicationId, string appId, string namePropertiesName, ApplicationInsightsApplicationType? applicationType, ComponentFlowType? flowType, ComponentRequestSource? requestSource, string instrumentationKey, DateTimeOffset? createdOn, Guid? tenantId, string hockeyAppId, string hockeyAppToken, string provisioningState, double? samplingPercentage, string connectionString, int? retentionInDays, bool? isDisableIPMasking, bool? isImmediatePurgeDataOn30Days, ResourceIdentifier workspaceResourceId, DateTimeOffset? laMigrationOn, IReadOnlyList<PrivateLinkScopedResourceReference> privateLinkScopedResources, ApplicationInsightsPublicNetworkAccessType? publicNetworkAccessForIngestion, ApplicationInsightsPublicNetworkAccessType? publicNetworkAccessForQuery, ComponentIngestionMode? ingestionMode, bool? isDisableLocalAuth, bool? isForceCustomerStorageForProfiler, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Kind = kind;
            ETag = etag;
            ApplicationId = applicationId;
            AppId = appId;
            NamePropertiesName = namePropertiesName;
            ApplicationType = applicationType;
            FlowType = flowType;
            RequestSource = requestSource;
            InstrumentationKey = instrumentationKey;
            CreatedOn = createdOn;
            TenantId = tenantId;
            HockeyAppId = hockeyAppId;
            HockeyAppToken = hockeyAppToken;
            ProvisioningState = provisioningState;
            SamplingPercentage = samplingPercentage;
            ConnectionString = connectionString;
            RetentionInDays = retentionInDays;
            IsDisableIPMasking = isDisableIPMasking;
            IsImmediatePurgeDataOn30Days = isImmediatePurgeDataOn30Days;
            WorkspaceResourceId = workspaceResourceId;
            LaMigrationOn = laMigrationOn;
            PrivateLinkScopedResources = privateLinkScopedResources;
            PublicNetworkAccessForIngestion = publicNetworkAccessForIngestion;
            PublicNetworkAccessForQuery = publicNetworkAccessForQuery;
            IngestionMode = ingestionMode;
            IsDisableLocalAuth = isDisableLocalAuth;
            IsForceCustomerStorageForProfiler = isForceCustomerStorageForProfiler;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ApplicationInsightsComponentData"/> for deserialization. </summary>
        internal ApplicationInsightsComponentData()
        {
        }

        /// <summary> The kind of application that this component refers to, used to customize UI. This value is a freeform string, values should typically be one of the following: web, ios, other, store, java, phone. </summary>
        [WirePath("kind")]
        public string Kind { get; set; }
        /// <summary> Resource etag. </summary>
        [WirePath("etag")]
        public ETag? ETag { get; set; }
        /// <summary> The unique ID of your application. This field mirrors the 'Name' field and cannot be changed. </summary>
        [WirePath("properties.ApplicationId")]
        public string ApplicationId { get; }
        /// <summary> Application Insights Unique ID for your Application. </summary>
        [WirePath("properties.AppId")]
        public string AppId { get; }
        /// <summary> Application name. </summary>
        [WirePath("properties.Name")]
        public string NamePropertiesName { get; }
        /// <summary> Type of application being monitored. </summary>
        [WirePath("properties.Application_Type")]
        public ApplicationInsightsApplicationType? ApplicationType { get; set; }
        /// <summary> Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API. </summary>
        [WirePath("properties.Flow_Type")]
        public ComponentFlowType? FlowType { get; set; }
        /// <summary> Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'. </summary>
        [WirePath("properties.Request_Source")]
        public ComponentRequestSource? RequestSource { get; set; }
        /// <summary> Application Insights Instrumentation key. A read-only value that applications can use to identify the destination for all telemetry sent to Azure Application Insights. This value will be supplied upon construction of each new Application Insights component. </summary>
        [WirePath("properties.InstrumentationKey")]
        public string InstrumentationKey { get; }
        /// <summary> Creation Date for the Application Insights component, in ISO 8601 format. </summary>
        [WirePath("properties.CreationDate")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Azure Tenant Id. </summary>
        [WirePath("properties.TenantId")]
        public Guid? TenantId { get; }
        /// <summary> The unique application ID created when a new application is added to HockeyApp, used for communications with HockeyApp. </summary>
        [WirePath("properties.HockeyAppId")]
        public string HockeyAppId { get; set; }
        /// <summary> Token used to authenticate communications with between Application Insights and HockeyApp. </summary>
        [WirePath("properties.HockeyAppToken")]
        public string HockeyAppToken { get; }
        /// <summary> Current state of this component: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed. </summary>
        [WirePath("properties.provisioningState")]
        public string ProvisioningState { get; }
        /// <summary> Percentage of the data produced by the application being monitored that is being sampled for Application Insights telemetry. </summary>
        [WirePath("properties.SamplingPercentage")]
        public double? SamplingPercentage { get; set; }
        /// <summary> Application Insights component connection string. </summary>
        [WirePath("properties.ConnectionString")]
        public string ConnectionString { get; }
        /// <summary> Retention period in days. </summary>
        [WirePath("properties.RetentionInDays")]
        public int? RetentionInDays { get; set; }
        /// <summary> Disable IP masking. </summary>
        [WirePath("properties.DisableIpMasking")]
        public bool? IsDisableIPMasking { get; set; }
        /// <summary> Purge data immediately after 30 days. </summary>
        [WirePath("properties.ImmediatePurgeDataOn30Days")]
        public bool? IsImmediatePurgeDataOn30Days { get; set; }
        /// <summary> Resource Id of the log analytics workspace which the data will be ingested to. This property is required to create an application with this API version. Applications from older versions will not have this property. </summary>
        [WirePath("properties.WorkspaceResourceId")]
        public ResourceIdentifier WorkspaceResourceId { get; set; }
        /// <summary> The date which the component got migrated to LA, in ISO 8601 format. </summary>
        [WirePath("properties.LaMigrationDate")]
        public DateTimeOffset? LaMigrationOn { get; }
        /// <summary> List of linked private link scope resources. </summary>
        [WirePath("properties.PrivateLinkScopedResources")]
        public IReadOnlyList<PrivateLinkScopedResourceReference> PrivateLinkScopedResources { get; }
        /// <summary> The network access type for accessing Application Insights ingestion. </summary>
        [WirePath("properties.publicNetworkAccessForIngestion")]
        public ApplicationInsightsPublicNetworkAccessType? PublicNetworkAccessForIngestion { get; set; }
        /// <summary> The network access type for accessing Application Insights query. </summary>
        [WirePath("properties.publicNetworkAccessForQuery")]
        public ApplicationInsightsPublicNetworkAccessType? PublicNetworkAccessForQuery { get; set; }
        /// <summary> Indicates the flow of the ingestion. </summary>
        [WirePath("properties.IngestionMode")]
        public ComponentIngestionMode? IngestionMode { get; set; }
        /// <summary> Disable Non-AAD based Auth. </summary>
        [WirePath("properties.DisableLocalAuth")]
        public bool? IsDisableLocalAuth { get; set; }
        /// <summary> Force users to create their own storage account for profiler and debugger. </summary>
        [WirePath("properties.ForceCustomerStorageForProfiler")]
        public bool? IsForceCustomerStorageForProfiler { get; set; }
    }
}
