// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.ApplicationInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApplicationInsights
{
    public partial class ApplicationInsightsComponentData : IUtf8JsonSerializable, IJsonModel<ApplicationInsightsComponentData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ApplicationInsightsComponentData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ApplicationInsightsComponentData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationInsightsComponentData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApplicationInsightsComponentData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("kind"u8);
            writer.WriteStringValue(Kind);
            if (Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ApplicationId))
            {
                writer.WritePropertyName("ApplicationId"u8);
                writer.WriteStringValue(ApplicationId);
            }
            if (options.Format != "W" && Optional.IsDefined(AppId))
            {
                writer.WritePropertyName("AppId"u8);
                writer.WriteStringValue(AppId);
            }
            if (options.Format != "W" && Optional.IsDefined(NamePropertiesName))
            {
                writer.WritePropertyName("Name"u8);
                writer.WriteStringValue(NamePropertiesName);
            }
            if (Optional.IsDefined(ApplicationType))
            {
                writer.WritePropertyName("Application_Type"u8);
                writer.WriteStringValue(ApplicationType.Value.ToString());
            }
            if (Optional.IsDefined(FlowType))
            {
                writer.WritePropertyName("Flow_Type"u8);
                writer.WriteStringValue(FlowType.Value.ToString());
            }
            if (Optional.IsDefined(RequestSource))
            {
                writer.WritePropertyName("Request_Source"u8);
                writer.WriteStringValue(RequestSource.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(InstrumentationKey))
            {
                writer.WritePropertyName("InstrumentationKey"u8);
                writer.WriteStringValue(InstrumentationKey);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("CreationDate"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(TenantId))
            {
                writer.WritePropertyName("TenantId"u8);
                writer.WriteStringValue(TenantId.Value);
            }
            if (Optional.IsDefined(HockeyAppId))
            {
                writer.WritePropertyName("HockeyAppId"u8);
                writer.WriteStringValue(HockeyAppId);
            }
            if (options.Format != "W" && Optional.IsDefined(HockeyAppToken))
            {
                writer.WritePropertyName("HockeyAppToken"u8);
                writer.WriteStringValue(HockeyAppToken);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState);
            }
            if (Optional.IsDefined(SamplingPercentage))
            {
                writer.WritePropertyName("SamplingPercentage"u8);
                writer.WriteNumberValue(SamplingPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ConnectionString))
            {
                writer.WritePropertyName("ConnectionString"u8);
                writer.WriteStringValue(ConnectionString);
            }
            if (Optional.IsDefined(RetentionInDays))
            {
                writer.WritePropertyName("RetentionInDays"u8);
                writer.WriteNumberValue(RetentionInDays.Value);
            }
            if (Optional.IsDefined(IsDisableIPMasking))
            {
                writer.WritePropertyName("DisableIpMasking"u8);
                writer.WriteBooleanValue(IsDisableIPMasking.Value);
            }
            if (Optional.IsDefined(IsImmediatePurgeDataOn30Days))
            {
                writer.WritePropertyName("ImmediatePurgeDataOn30Days"u8);
                writer.WriteBooleanValue(IsImmediatePurgeDataOn30Days.Value);
            }
            if (Optional.IsDefined(WorkspaceResourceId))
            {
                writer.WritePropertyName("WorkspaceResourceId"u8);
                writer.WriteStringValue(WorkspaceResourceId);
            }
            if (options.Format != "W" && Optional.IsDefined(LaMigrationOn))
            {
                writer.WritePropertyName("LaMigrationDate"u8);
                writer.WriteStringValue(LaMigrationOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PrivateLinkScopedResources))
            {
                writer.WritePropertyName("PrivateLinkScopedResources"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateLinkScopedResources)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PublicNetworkAccessForIngestion))
            {
                writer.WritePropertyName("publicNetworkAccessForIngestion"u8);
                writer.WriteStringValue(PublicNetworkAccessForIngestion.Value.ToString());
            }
            if (Optional.IsDefined(PublicNetworkAccessForQuery))
            {
                writer.WritePropertyName("publicNetworkAccessForQuery"u8);
                writer.WriteStringValue(PublicNetworkAccessForQuery.Value.ToString());
            }
            if (Optional.IsDefined(IngestionMode))
            {
                writer.WritePropertyName("IngestionMode"u8);
                writer.WriteStringValue(IngestionMode.Value.ToString());
            }
            if (Optional.IsDefined(IsDisableLocalAuth))
            {
                writer.WritePropertyName("DisableLocalAuth"u8);
                writer.WriteBooleanValue(IsDisableLocalAuth.Value);
            }
            if (Optional.IsDefined(IsForceCustomerStorageForProfiler))
            {
                writer.WritePropertyName("ForceCustomerStorageForProfiler"u8);
                writer.WriteBooleanValue(IsForceCustomerStorageForProfiler.Value);
            }
            writer.WriteEndObject();
        }

        ApplicationInsightsComponentData IJsonModel<ApplicationInsightsComponentData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationInsightsComponentData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApplicationInsightsComponentData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeApplicationInsightsComponentData(document.RootElement, options);
        }

        internal static ApplicationInsightsComponentData DeserializeApplicationInsightsComponentData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string kind = default;
            ETag? etag = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string applicationId = default;
            string appId = default;
            string name0 = default;
            ApplicationInsightsApplicationType? applicationType = default;
            ComponentFlowType? flowType = default;
            ComponentRequestSource? requestSource = default;
            string instrumentationKey = default;
            DateTimeOffset? creationDate = default;
            Guid? tenantId = default;
            string hockeyAppId = default;
            string hockeyAppToken = default;
            string provisioningState = default;
            double? samplingPercentage = default;
            string connectionString = default;
            int? retentionInDays = default;
            bool? disableIPMasking = default;
            bool? immediatePurgeDataOn30Days = default;
            ResourceIdentifier workspaceResourceId = default;
            DateTimeOffset? laMigrationDate = default;
            IReadOnlyList<PrivateLinkScopedResourceReference> privateLinkScopedResources = default;
            ApplicationInsightsPublicNetworkAccessType? publicNetworkAccessForIngestion = default;
            ApplicationInsightsPublicNetworkAccessType? publicNetworkAccessForQuery = default;
            ComponentIngestionMode? ingestionMode = default;
            bool? disableLocalAuth = default;
            bool? forceCustomerStorageForProfiler = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("kind"u8))
                {
                    kind = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("ApplicationId"u8))
                        {
                            applicationId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("AppId"u8))
                        {
                            appId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("Name"u8))
                        {
                            name0 = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("Application_Type"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            applicationType = new ApplicationInsightsApplicationType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("Flow_Type"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            flowType = new ComponentFlowType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("Request_Source"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            requestSource = new ComponentRequestSource(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("InstrumentationKey"u8))
                        {
                            instrumentationKey = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("CreationDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            creationDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("TenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            tenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("HockeyAppId"u8))
                        {
                            hockeyAppId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("HockeyAppToken"u8))
                        {
                            hockeyAppToken = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            provisioningState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("SamplingPercentage"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            samplingPercentage = property0.Value.GetDouble();
                            continue;
                        }
                        if (property0.NameEquals("ConnectionString"u8))
                        {
                            connectionString = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("RetentionInDays"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            retentionInDays = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("DisableIpMasking"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            disableIPMasking = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("ImmediatePurgeDataOn30Days"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            immediatePurgeDataOn30Days = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("WorkspaceResourceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            workspaceResourceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("LaMigrationDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            laMigrationDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("PrivateLinkScopedResources"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PrivateLinkScopedResourceReference> array = new List<PrivateLinkScopedResourceReference>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PrivateLinkScopedResourceReference.DeserializePrivateLinkScopedResourceReference(item, options));
                            }
                            privateLinkScopedResources = array;
                            continue;
                        }
                        if (property0.NameEquals("publicNetworkAccessForIngestion"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            publicNetworkAccessForIngestion = new ApplicationInsightsPublicNetworkAccessType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("publicNetworkAccessForQuery"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            publicNetworkAccessForQuery = new ApplicationInsightsPublicNetworkAccessType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("IngestionMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            ingestionMode = new ComponentIngestionMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("DisableLocalAuth"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            disableLocalAuth = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("ForceCustomerStorageForProfiler"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            forceCustomerStorageForProfiler = property0.Value.GetBoolean();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ApplicationInsightsComponentData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                kind,
                etag,
                applicationId,
                appId,
                name0,
                applicationType,
                flowType,
                requestSource,
                instrumentationKey,
                creationDate,
                tenantId,
                hockeyAppId,
                hockeyAppToken,
                provisioningState,
                samplingPercentage,
                connectionString,
                retentionInDays,
                disableIPMasking,
                immediatePurgeDataOn30Days,
                workspaceResourceId,
                laMigrationDate,
                privateLinkScopedResources ?? new ChangeTrackingList<PrivateLinkScopedResourceReference>(),
                publicNetworkAccessForIngestion,
                publicNetworkAccessForQuery,
                ingestionMode,
                disableLocalAuth,
                forceCustomerStorageForProfiler,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  location: ");
                builder.AppendLine($"'{Location.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Kind), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  kind: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Kind))
                {
                    builder.Append("  kind: ");
                    if (Kind.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Kind}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Kind}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ETag), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  etag: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ETag))
                {
                    builder.Append("  etag: ");
                    builder.AppendLine($"'{ETag.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApplicationId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    ApplicationId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ApplicationId))
                {
                    builder.Append("    ApplicationId: ");
                    if (ApplicationId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ApplicationId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ApplicationId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AppId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    AppId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AppId))
                {
                    builder.Append("    AppId: ");
                    if (AppId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AppId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AppId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NamePropertiesName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    Name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NamePropertiesName))
                {
                    builder.Append("    Name: ");
                    if (NamePropertiesName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NamePropertiesName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NamePropertiesName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApplicationType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    Application_Type: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ApplicationType))
                {
                    builder.Append("    Application_Type: ");
                    builder.AppendLine($"'{ApplicationType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FlowType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    Flow_Type: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FlowType))
                {
                    builder.Append("    Flow_Type: ");
                    builder.AppendLine($"'{FlowType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RequestSource), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    Request_Source: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RequestSource))
                {
                    builder.Append("    Request_Source: ");
                    builder.AppendLine($"'{RequestSource.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InstrumentationKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    InstrumentationKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InstrumentationKey))
                {
                    builder.Append("    InstrumentationKey: ");
                    if (InstrumentationKey.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{InstrumentationKey}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{InstrumentationKey}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreatedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    CreationDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreatedOn))
                {
                    builder.Append("    CreationDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(CreatedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    TenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TenantId))
                {
                    builder.Append("    TenantId: ");
                    builder.AppendLine($"'{TenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HockeyAppId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    HockeyAppId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HockeyAppId))
                {
                    builder.Append("    HockeyAppId: ");
                    if (HockeyAppId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{HockeyAppId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{HockeyAppId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HockeyAppToken), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    HockeyAppToken: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HockeyAppToken))
                {
                    builder.Append("    HockeyAppToken: ");
                    if (HockeyAppToken.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{HockeyAppToken}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{HockeyAppToken}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    if (ProvisioningState.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProvisioningState}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProvisioningState}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SamplingPercentage), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    SamplingPercentage: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SamplingPercentage))
                {
                    builder.Append("    SamplingPercentage: ");
                    builder.AppendLine($"'{SamplingPercentage.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConnectionString), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    ConnectionString: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConnectionString))
                {
                    builder.Append("    ConnectionString: ");
                    if (ConnectionString.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ConnectionString}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ConnectionString}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RetentionInDays), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    RetentionInDays: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RetentionInDays))
                {
                    builder.Append("    RetentionInDays: ");
                    builder.AppendLine($"{RetentionInDays.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsDisableIPMasking), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    DisableIpMasking: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsDisableIPMasking))
                {
                    builder.Append("    DisableIpMasking: ");
                    var boolValue = IsDisableIPMasking.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsImmediatePurgeDataOn30Days), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    ImmediatePurgeDataOn30Days: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsImmediatePurgeDataOn30Days))
                {
                    builder.Append("    ImmediatePurgeDataOn30Days: ");
                    var boolValue = IsImmediatePurgeDataOn30Days.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WorkspaceResourceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    WorkspaceResourceId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WorkspaceResourceId))
                {
                    builder.Append("    WorkspaceResourceId: ");
                    builder.AppendLine($"'{WorkspaceResourceId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LaMigrationOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    LaMigrationDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LaMigrationOn))
                {
                    builder.Append("    LaMigrationDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LaMigrationOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrivateLinkScopedResources), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    PrivateLinkScopedResources: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PrivateLinkScopedResources))
                {
                    if (PrivateLinkScopedResources.Any())
                    {
                        builder.Append("    PrivateLinkScopedResources: ");
                        builder.AppendLine("[");
                        foreach (var item in PrivateLinkScopedResources)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    PrivateLinkScopedResources: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PublicNetworkAccessForIngestion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publicNetworkAccessForIngestion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PublicNetworkAccessForIngestion))
                {
                    builder.Append("    publicNetworkAccessForIngestion: ");
                    builder.AppendLine($"'{PublicNetworkAccessForIngestion.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PublicNetworkAccessForQuery), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publicNetworkAccessForQuery: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PublicNetworkAccessForQuery))
                {
                    builder.Append("    publicNetworkAccessForQuery: ");
                    builder.AppendLine($"'{PublicNetworkAccessForQuery.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IngestionMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    IngestionMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IngestionMode))
                {
                    builder.Append("    IngestionMode: ");
                    builder.AppendLine($"'{IngestionMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsDisableLocalAuth), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    DisableLocalAuth: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsDisableLocalAuth))
                {
                    builder.Append("    DisableLocalAuth: ");
                    var boolValue = IsDisableLocalAuth.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsForceCustomerStorageForProfiler), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    ForceCustomerStorageForProfiler: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsForceCustomerStorageForProfiler))
                {
                    builder.Append("    ForceCustomerStorageForProfiler: ");
                    var boolValue = IsForceCustomerStorageForProfiler.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ApplicationInsightsComponentData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationInsightsComponentData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ApplicationInsightsComponentData)} does not support writing '{options.Format}' format.");
            }
        }

        ApplicationInsightsComponentData IPersistableModel<ApplicationInsightsComponentData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationInsightsComponentData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeApplicationInsightsComponentData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ApplicationInsightsComponentData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ApplicationInsightsComponentData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
