// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ApplicationInsights.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ApplicationInsights.Samples
{
    public partial class Sample_ApplicationInsightsComponentResource
    {
        // ComponentsList.json
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetApplicationInsightsComponents_ComponentsListJson()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2020-02-02/examples/ComponentsList.json
            // this example is just showing the usage of "Components_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "subid";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (ApplicationInsightsComponentResource item in subscriptionResource.GetApplicationInsightsComponentsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ApplicationInsightsComponentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ComponentsDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ComponentsDelete()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2020-02-02/examples/ComponentsDelete.json
            // this example is just showing the usage of "Components_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            await applicationInsightsComponent.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ComponentGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ComponentGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2020-02-02/examples/ComponentsGet.json
            // this example is just showing the usage of "Components_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            ApplicationInsightsComponentResource result = await applicationInsightsComponent.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApplicationInsightsComponentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ComponentUpdateTagsOnly
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ComponentUpdateTagsOnly()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2020-02-02/examples/ComponentsUpdateTagsOnly.json
            // this example is just showing the usage of "Components_UpdateTags" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            WebTestComponentTag componentTags = new WebTestComponentTag()
            {
                Tags =
{
["ApplicationGatewayType"] = "Internal-Only",
["BillingEntity"] = "Self",
["Color"] = "AzureBlue",
["CustomField_01"] = "Custom text in some random field named randomly",
["NodeType"] = "Edge",
},
            };
            ApplicationInsightsComponentResource result = await applicationInsightsComponent.UpdateAsync(componentTags);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApplicationInsightsComponentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ComponentPurge
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Purge_ComponentPurge()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2020-02-02/examples/ComponentsPurge.json
            // this example is just showing the usage of "Components_Purge" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "OIAutoRest5123";
            string resourceName = "aztest5048";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            ComponentPurgeContent content = new ComponentPurgeContent("Heartbeat", new ComponentPurgeFilters[]
            {
new ComponentPurgeFilters()
{
Column = "TimeGenerated",
Operator = ">",
Value = BinaryData.FromString("\"2017-09-01T00:00:00\""),
}
            });
            ComponentPurgeResult result = await applicationInsightsComponent.PurgeAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ComponentPurge
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetPurgeStatus_ComponentPurge()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2020-02-02/examples/ComponentsPurgeStatus.json
            // this example is just showing the usage of "Components_GetPurgeStatus" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "OIAutoRest5123";
            string resourceName = "aztest5048";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string purgeId = "purge-970318e7-b859-4edb-8903-83b1b54d0b74";
            ComponentPurgeStatusResult result = await applicationInsightsComponent.GetPurgeStatusAsync(purgeId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // AnnotationsList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAnnotations_AnnotationsList()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/AnnotationsList.json
            // this example is just showing the usage of "Annotations_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            string start = "2018-02-05T00%253A30%253A00.000Z";
            string end = "2018-02-06T00%253A33A00.000Z";
            await foreach (ApplicationInsightsAnnotation item in applicationInsightsComponent.GetAnnotationsAsync(start, end))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // AnnotationsCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateAnnotations_AnnotationsCreate()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/AnnotationsCreate.json
            // this example is just showing the usage of "Annotations_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            ApplicationInsightsAnnotation annotationProperties = new ApplicationInsightsAnnotation()
            {
                AnnotationName = "TestAnnotation",
                Category = "Text",
                EventOccurredOn = DateTimeOffset.Parse("2018-01-31T13:41:38.657Z"),
                Id = "444e2c08-274a-4bbb-a89e-d77bb720f44a",
                Properties = "{\"Comments\":\"Testing\",\"Label\":\"Success\"}",
            };
            await foreach (ApplicationInsightsAnnotation item in applicationInsightsComponent.CreateAnnotationsAsync(annotationProperties))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // AnnotationsDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteAnnotation_AnnotationsDelete()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/AnnotationsDelete.json
            // this example is just showing the usage of "Annotations_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string annotationId = "bb820f1b-3110-4a8b-ba2c-8c1129d7eb6a";
            await applicationInsightsComponent.DeleteAnnotationAsync(annotationId);

            Console.WriteLine($"Succeeded");
        }

        // AnnotationsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAnnotations_AnnotationsGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/AnnotationsGet.json
            // this example is just showing the usage of "Annotations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            string annotationId = "444e2c08-274a-4bbb-a89e-d77bb720f44a";
            await foreach (ApplicationInsightsAnnotation item in applicationInsightsComponent.GetAnnotationsAsync(annotationId))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // APIKeysList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetApiKeys_APIKeysList()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/APIKeysList.json
            // this example is just showing the usage of "APIKeys_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            await foreach (ApplicationInsightsComponentApiKey item in applicationInsightsComponent.GetApiKeysAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // APIKeyCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateApiKey_APIKeyCreate()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/APIKeysCreate.json
            // this example is just showing the usage of "APIKeys_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            ApplicationInsightsApiKeyContent content = new ApplicationInsightsApiKeyContent()
            {
                Name = "test2",
                LinkedReadProperties =
{
"/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.Insights/components/my-component/api","/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.Insights/components/my-component/agentconfig"
},
                LinkedWriteProperties =
{
"/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.Insights/components/my-component/annotations"
},
            };
            ApplicationInsightsComponentApiKey result = await applicationInsightsComponent.CreateApiKeyAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // APIKeyDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteApiKey_APIKeyDelete()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/APIKeysDelete.json
            // this example is just showing the usage of "APIKeys_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string keyId = "bb820f1b-3110-4a8b-ba2c-8c1129d7eb6a";
            ApplicationInsightsComponentApiKey result = await applicationInsightsComponent.DeleteApiKeyAsync(keyId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // APIKeysGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetApiKey_APIKeysGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/APIKeysGet.json
            // this example is just showing the usage of "APIKeys_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string keyId = "bb820f1b-3110-4a8b-ba2c-8c1129d7eb6a";
            ApplicationInsightsComponentApiKey result = await applicationInsightsComponent.GetApiKeyAsync(keyId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ExportConfigurationsList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetExportConfigurations_ExportConfigurationsList()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/ExportConfigurationsList.json
            // this example is just showing the usage of "ExportConfigurations_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            await foreach (ApplicationInsightsComponentExportConfiguration item in applicationInsightsComponent.GetExportConfigurationsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ExportConfigurationPost
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateExportConfigurations_ExportConfigurationPost()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/ExportConfigurationsPost.json
            // this example is just showing the usage of "ExportConfigurations_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            ApplicationInsightsComponentExportContent content = new ApplicationInsightsComponentExportContent()
            {
                RecordTypes = "Requests, Event, Exceptions, Metrics, PageViews, PageViewPerformance, Rdd, PerformanceCounters, Availability",
                DestinationType = "Blob",
                DestinationAddress = "https://mystorageblob.blob.core.windows.net/testexport?sv=2015-04-05&sr=c&sig=token",
                IsEnabled = "true",
                IsNotificationQueueEnabled = "false",
                NotificationQueueUri = new Uri(""),
                DestinationStorageSubscriptionId = "subid",
                DestinationStorageLocationId = "eastus",
                DestinationAccountId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.ClassicStorage/storageAccounts/mystorageblob"),
            };
            await foreach (ApplicationInsightsComponentExportConfiguration item in applicationInsightsComponent.CreateExportConfigurationsAsync(content))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ExportConfigurationDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteExportConfiguration_ExportConfigurationDelete()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/ExportConfigurationDelete.json
            // this example is just showing the usage of "ExportConfigurations_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string exportId = "uGOoki0jQsyEs3IdQ83Q4QsNr4=";
            ApplicationInsightsComponentExportConfiguration result = await applicationInsightsComponent.DeleteExportConfigurationAsync(exportId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ExportConfigurationGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetExportConfiguration_ExportConfigurationGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/ExportConfigurationGet.json
            // this example is just showing the usage of "ExportConfigurations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string exportId = "uGOoki0jQsyEs3IdQ83Q4QsNr4=";
            ApplicationInsightsComponentExportConfiguration result = await applicationInsightsComponent.GetExportConfigurationAsync(exportId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ExportConfigurationUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateExportConfiguration_ExportConfigurationUpdate()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/ExportConfigurationUpdate.json
            // this example is just showing the usage of "ExportConfigurations_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string exportId = "uGOoki0jQsyEs3IdQ83Q4QsNr4=";
            ApplicationInsightsComponentExportContent content = new ApplicationInsightsComponentExportContent()
            {
                RecordTypes = "Requests, Event, Exceptions, Metrics, PageViews, PageViewPerformance, Rdd, PerformanceCounters, Availability",
                DestinationType = "Blob",
                DestinationAddress = "https://mystorageblob.blob.core.windows.net/fchentest?sv=2015-04-05&sr=c&sig=token",
                IsEnabled = "true",
                IsNotificationQueueEnabled = "false",
                NotificationQueueUri = new Uri(""),
                DestinationStorageSubscriptionId = "subid",
                DestinationStorageLocationId = "eastus",
                DestinationAccountId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/my-resource-group/providers/Microsoft.ClassicStorage/storageAccounts/mystorageblob"),
            };
            ApplicationInsightsComponentExportConfiguration result = await applicationInsightsComponent.UpdateExportConfigurationAsync(exportId, content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ComponentCurrentBillingFeaturesGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetComponentCurrentBillingFeature_ComponentCurrentBillingFeaturesGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/CurrentBillingFeaturesGet.json
            // this example is just showing the usage of "ComponentCurrentBillingFeatures_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            ApplicationInsightsComponentBillingFeatures result = await applicationInsightsComponent.GetComponentCurrentBillingFeatureAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ComponentCurrentBillingFeaturesUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateComponentCurrentBillingFeature_ComponentCurrentBillingFeaturesUpdate()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/CurrentBillingFeaturesUpdate.json
            // this example is just showing the usage of "ComponentCurrentBillingFeatures_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            ApplicationInsightsComponentBillingFeatures billingFeaturesProperties = new ApplicationInsightsComponentBillingFeatures()
            {
                DataVolumeCap = new ApplicationInsightsComponentDataVolumeCap()
                {
                    Cap = 100,
                    IsStopSendNotificationWhenHitCap = true,
                },
                CurrentBillingFeatures =
{
"Basic","Application Insights Enterprise"
},
            };
            ApplicationInsightsComponentBillingFeatures result = await applicationInsightsComponent.UpdateComponentCurrentBillingFeatureAsync(billingFeaturesProperties);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ComponentCurrentBillingFeaturesGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetComponentQuotaStatus_ComponentCurrentBillingFeaturesGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/QuotaStatusGet.json
            // this example is just showing the usage of "ComponentQuotaStatus_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            ApplicationInsightsComponentQuotaStatus result = await applicationInsightsComponent.GetComponentQuotaStatusAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ComponentCurrentBillingFeaturesGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetComponentFeatureCapability_ComponentCurrentBillingFeaturesGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/FeatureCapabilitiesGet.json
            // this example is just showing the usage of "ComponentFeatureCapabilities_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            ApplicationInsightsComponentFeatureCapabilities result = await applicationInsightsComponent.GetComponentFeatureCapabilityAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ComponentCurrentBillingFeaturesGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetComponentAvailableFeature_ComponentCurrentBillingFeaturesGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/AvailableBillingFeaturesGet.json
            // this example is just showing the usage of "ComponentAvailableFeatures_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            ApplicationInsightsComponentAvailableFeatures result = await applicationInsightsComponent.GetComponentAvailableFeatureAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ProactiveDetectionConfigurationsList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetProactiveDetectionConfigurations_ProactiveDetectionConfigurationsList()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/ProactiveDetectionConfigurationsList.json
            // this example is just showing the usage of "ProactiveDetectionConfigurations_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            await foreach (ApplicationInsightsComponentProactiveDetectionConfiguration item in applicationInsightsComponent.GetProactiveDetectionConfigurationsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ProactiveDetectionConfigurationGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetProactiveDetectionConfiguration_ProactiveDetectionConfigurationGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/ProactiveDetectionConfigurationGet.json
            // this example is just showing the usage of "ProactiveDetectionConfigurations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string configurationId = "slowpageloadtime";
            ApplicationInsightsComponentProactiveDetectionConfiguration result = await applicationInsightsComponent.GetProactiveDetectionConfigurationAsync(configurationId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ProactiveDetectionConfigurationUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateProactiveDetectionConfiguration_ProactiveDetectionConfigurationUpdate()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/ProactiveDetectionConfigurationUpdate.json
            // this example is just showing the usage of "ProactiveDetectionConfigurations_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string configurationId = "slowpageloadtime";
            ApplicationInsightsComponentProactiveDetectionConfiguration proactiveDetectionProperties = new ApplicationInsightsComponentProactiveDetectionConfiguration()
            {
                Name = "slowpageloadtime",
                IsEnabled = true,
                SendEmailsToSubscriptionOwners = true,
                CustomEmails =
{
"foo@microsoft.com","foo2@microsoft.com"
},
                LastUpdatedOn = null,
                RuleDefinitions = new ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions()
                {
                    Name = "slowpageloadtime",
                    DisplayName = "Slow page load time",
                    Description = "Smart Detection rules notify you of performance anomaly issues.",
                    HelpUri = new Uri("https://docs.microsoft.com/en-us/azure/application-insights/app-insights-proactive-performance-diagnostics"),
                    IsHidden = false,
                    IsEnabledByDefault = true,
                    IsInPreview = false,
                    IsEmailNotificationsSupported = true,
                },
            };
            ApplicationInsightsComponentProactiveDetectionConfiguration result = await applicationInsightsComponent.UpdateProactiveDetectionConfigurationAsync(configurationId, proactiveDetectionProperties);

            Console.WriteLine($"Succeeded: {result}");
        }

        // WorkItemConfigurationsList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetWorkItemConfigurations_WorkItemConfigurationsList()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/WorkItemConfigsGet.json
            // this example is just showing the usage of "WorkItemConfigurations_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            await foreach (WorkItemConfiguration item in applicationInsightsComponent.GetWorkItemConfigurationsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // WorkItemConfigurationsGetDefault
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDefaultWorkItemConfiguration_WorkItemConfigurationsGetDefault()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/WorkItemConfigDefaultGet.json
            // this example is just showing the usage of "WorkItemConfigurations_GetDefault" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            WorkItemConfiguration result = await applicationInsightsComponent.GetDefaultWorkItemConfigurationAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // WorkItemConfigurationDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteWorkItemConfiguration_WorkItemConfigurationDelete()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/WorkItemConfigDelete.json
            // this example is just showing the usage of "WorkItemConfigurations_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string workItemConfigId = "Visual Studio Team Services";
            await applicationInsightsComponent.DeleteWorkItemConfigurationAsync(workItemConfigId);

            Console.WriteLine($"Succeeded");
        }

        // WorkItemConfigurationsGetDefault
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetItemWorkItemConfiguration_WorkItemConfigurationsGetDefault()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/WorkItemConfigGet.json
            // this example is just showing the usage of "WorkItemConfigurations_GetItem" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string workItemConfigId = "Visual Studio Team Services";
            WorkItemConfiguration result = await applicationInsightsComponent.GetItemWorkItemConfigurationAsync(workItemConfigId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // FavoritesList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetFavorites_FavoritesList()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/FavoritesList.json
            // this example is just showing the usage of "Favorites_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-ai-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            await foreach (ApplicationInsightsComponentFavorite item in applicationInsightsComponent.GetFavoritesAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // FavoriteGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetFavorite_FavoriteGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/FavoriteGet.json
            // this example is just showing the usage of "Favorites_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-ai-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string favoriteId = "deadb33f-5e0d-4064-8ebb-1a4ed0313eb2";
            ApplicationInsightsComponentFavorite result = await applicationInsightsComponent.GetFavoriteAsync(favoriteId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // FavoriteAdd
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task AddFavorite_FavoriteAdd()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/FavoriteAdd.json
            // this example is just showing the usage of "Favorites_Add" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-ai-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string favoriteId = "deadb33f-8bee-4d3b-a059-9be8dac93960";
            ApplicationInsightsComponentFavorite favoriteProperties = new ApplicationInsightsComponentFavorite()
            {
                Name = "Blah Blah Blah",
                Config = "{\"MEDataModelRawJSON\":\"{\\n  \\\"version\\\": \\\"1.4.1\\\",\\n  \\\"isCustomDataModel\\\": true,\\n  \\\"items\\\": [\\n    {\\n      \\\"id\\\": \\\"90a7134d-9a38-4c25-88d3-a495209873eb\\\",\\n      \\\"chartType\\\": \\\"Area\\\",\\n      \\\"chartHeight\\\": 4,\\n      \\\"metrics\\\": [\\n        {\\n          \\\"id\\\": \\\"preview/requests/count\\\",\\n          \\\"metricAggregation\\\": \\\"Sum\\\",\\n          \\\"color\\\": \\\"msportalfx-bgcolor-d0\\\"\\n        }\\n      ],\\n      \\\"priorPeriod\\\": false,\\n      \\\"clickAction\\\": {\\n        \\\"defaultBlade\\\": \\\"SearchBlade\\\"\\n      },\\n      \\\"horizontalBars\\\": true,\\n      \\\"showOther\\\": true,\\n      \\\"aggregation\\\": \\\"Sum\\\",\\n      \\\"percentage\\\": false,\\n      \\\"palette\\\": \\\"fail\\\",\\n      \\\"yAxisOption\\\": 0,\\n      \\\"title\\\": \\\"\\\"\\n    },\\n    {\\n      \\\"id\\\": \\\"0c289098-88e8-4010-b212-546815cddf70\\\",\\n      \\\"chartType\\\": \\\"Area\\\",\\n      \\\"chartHeight\\\": 2,\\n      \\\"metrics\\\": [\\n        {\\n          \\\"id\\\": \\\"preview/requests/duration\\\",\\n          \\\"metricAggregation\\\": \\\"Avg\\\",\\n          \\\"color\\\": \\\"msportalfx-bgcolor-j1\\\"\\n        }\\n      ],\\n      \\\"priorPeriod\\\": false,\\n      \\\"clickAction\\\": {\\n        \\\"defaultBlade\\\": \\\"SearchBlade\\\"\\n      },\\n      \\\"horizontalBars\\\": true,\\n      \\\"showOther\\\": true,\\n      \\\"aggregation\\\": \\\"Avg\\\",\\n      \\\"percentage\\\": false,\\n      \\\"palette\\\": \\\"greenHues\\\",\\n      \\\"yAxisOption\\\": 0,\\n      \\\"title\\\": \\\"\\\"\\n    },\\n    {\\n      \\\"id\\\": \\\"cbdaab6f-a808-4f71-aca5-b3976cbb7345\\\",\\n      \\\"chartType\\\": \\\"Bar\\\",\\n      \\\"chartHeight\\\": 4,\\n      \\\"metrics\\\": [\\n        {\\n          \\\"id\\\": \\\"preview/requests/duration\\\",\\n          \\\"metricAggregation\\\": \\\"Avg\\\",\\n          \\\"color\\\": \\\"msportalfx-bgcolor-d0\\\"\\n        }\\n      ],\\n      \\\"priorPeriod\\\": false,\\n      \\\"clickAction\\\": {\\n        \\\"defaultBlade\\\": \\\"SearchBlade\\\"\\n      },\\n      \\\"horizontalBars\\\": true,\\n      \\\"showOther\\\": true,\\n      \\\"aggregation\\\": \\\"Avg\\\",\\n      \\\"percentage\\\": false,\\n      \\\"palette\\\": \\\"magentaHues\\\",\\n      \\\"yAxisOption\\\": 0,\\n      \\\"title\\\": \\\"\\\"\\n    },\\n    {\\n      \\\"id\\\": \\\"1d5a6a3a-9fa1-4099-9cf9-05eff72d1b02\\\",\\n      \\\"grouping\\\": {\\n        \\\"kind\\\": \\\"ByDimension\\\",\\n        \\\"dimension\\\": \\\"context.application.version\\\"\\n      },\\n      \\\"chartType\\\": \\\"Grid\\\",\\n      \\\"chartHeight\\\": 1,\\n      \\\"metrics\\\": [\\n        {\\n          \\\"id\\\": \\\"basicException.count\\\",\\n          \\\"metricAggregation\\\": \\\"Sum\\\",\\n          \\\"color\\\": \\\"msportalfx-bgcolor-g0\\\"\\n        },\\n        {\\n          \\\"id\\\": \\\"requestFailed.count\\\",\\n          \\\"metricAggregation\\\": \\\"Sum\\\",\\n          \\\"color\\\": \\\"msportalfx-bgcolor-f0s2\\\"\\n        }\\n      ],\\n      \\\"priorPeriod\\\": true,\\n      \\\"clickAction\\\": {\\n        \\\"defaultBlade\\\": \\\"SearchBlade\\\"\\n      },\\n      \\\"horizontalBars\\\": true,\\n      \\\"showOther\\\": true,\\n      \\\"percentage\\\": false,\\n      \\\"palette\\\": \\\"blueHues\\\",\\n      \\\"yAxisOption\\\": 0,\\n      \\\"title\\\": \\\"\\\"\\n    }\\n  ],\\n  \\\"currentFilter\\\": {\\n    \\\"eventTypes\\\": [\\n      1,\\n      2\\n    ],\\n    \\\"typeFacets\\\": {},\\n    \\\"isPermissive\\\": false\\n  },\\n  \\\"timeContext\\\": {\\n    \\\"durationMs\\\": 75600000,\\n    \\\"endTime\\\": \\\"2018-01-31T20:30:00.000Z\\\",\\n    \\\"createdTime\\\": \\\"2018-01-31T23:54:26.280Z\\\",\\n    \\\"isInitialTime\\\": false,\\n    \\\"grain\\\": 1,\\n    \\\"useDashboardTimeRange\\\": false\\n  },\\n  \\\"jsonUri\\\": \\\"Favorite_BlankChart\\\",\\n  \\\"timeSource\\\": 0\\n}\"}",
                Version = "ME",
                FavoriteType = ComponentFavoriteType.Shared,
                SourceType = null,
                Tags =
{
"TagSample01","TagSample02"
},
                Category = null,
                IsGeneratedFromTemplate = false,
            };
            ApplicationInsightsComponentFavorite result = await applicationInsightsComponent.AddFavoriteAsync(favoriteId, favoriteProperties);

            Console.WriteLine($"Succeeded: {result}");
        }

        // FavoriteList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateFavorite_FavoriteList()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/FavoriteUpdate.json
            // this example is just showing the usage of "Favorites_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-ai-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string favoriteId = "deadb33f-5e0d-4064-8ebb-1a4ed0313eb2";
            ApplicationInsightsComponentFavorite favoriteProperties = new ApplicationInsightsComponentFavorite()
            {
                Name = "Derek Changed This",
                Config = "{\"MEDataModelRawJSON\":\"{\\\"version\\\": \\\"1.4.1\\\",\\\"isCustomDataModel\\\": true,\\\"items\\\": [{\\\"id\\\": \\\"90a7134d-9a38-4c25-88d3-a495209873eb\\\",\\\"chartType\\\": \\\"Area\\\",\\\"chartHeight\\\": 4,\\\"metrics\\\": [{\\\"id\\\": \\\"preview/requests/count\\\",\\\"metricAggregation\\\": \\\"Sum\\\",\\\"color\\\": \\\"msportalfx-bgcolor-d0\\\"}],\\\"priorPeriod\\\": false,\\\"clickAction\\\": {\\\"defaultBlade\\\": \\\"SearchBlade\\\"},\\\"horizontalBars\\\": true,\\\"showOther\\\": true,\\\"aggregation\\\": \\\"Sum\\\",\\\"percentage\\\": false,\\\"palette\\\": \\\"fail\\\",\\\"yAxisOption\\\": 0,\\\"title\\\": \\\"\\\"},{\\\"id\\\": \\\"0c289098-88e8-4010-b212-546815cddf70\\\",\\\"chartType\\\": \\\"Area\\\",\\\"chartHeight\\\": 2,\\\"metrics\\\": [{\\\"id\\\": \\\"preview/requests/duration\\\",\\\"metricAggregation\\\": \\\"Avg\\\",\\\"color\\\": \\\"msportalfx-bgcolor-j1\\\"}],\\\"priorPeriod\\\": false,\\\"clickAction\\\": {\\\"defaultBlade\\\": \\\"SearchBlade\\\"},\\\"horizontalBars\\\": true,\\\"showOther\\\": true,\\\"aggregation\\\": \\\"Avg\\\",\\\"percentage\\\": false,\\\"palette\\\": \\\"greenHues\\\",\\\"yAxisOption\\\": 0,\\\"title\\\": \\\"\\\"},{\\\"id\\\": \\\"cbdaab6f-a808-4f71-aca5-b3976cbb7345\\\",\\\"chartType\\\": \\\"Bar\\\",\\\"chartHeight\\\": 4,\\\"metrics\\\": [{\\\"id\\\": \\\"preview/requests/duration\\\",\\\"metricAggregation\\\": \\\"Avg\\\",\\\"color\\\": \\\"msportalfx-bgcolor-d0\\\"}],\\\"priorPeriod\\\": false,\\\"clickAction\\\": {\\\"defaultBlade\\\": \\\"SearchBlade\\\"},\\\"horizontalBars\\\": true,\\\"showOther\\\": true,\\\"aggregation\\\": \\\"Avg\\\",\\\"percentage\\\": false,\\\"palette\\\": \\\"magentaHues\\\",\\\"yAxisOption\\\": 0,\\\"title\\\": \\\"\\\"},{\\\"id\\\": \\\"1d5a6a3a-9fa1-4099-9cf9-05eff72d1b02\\\",\\\"grouping\\\": {\\\"kind\\\": \\\"ByDimension\\\",\\\"dimension\\\": \\\"context.application.version\\\"},\\\"chartType\\\": \\\"Grid\\\",\\\"chartHeight\\\": 1,\\\"metrics\\\": [{\\\"id\\\": \\\"basicException.count\\\",\\\"metricAggregation\\\": \\\"Sum\\\",\\\"color\\\": \\\"msportalfx-bgcolor-g0\\\"},{\\\"id\\\": \\\"requestFailed.count\\\",\\\"metricAggregation\\\": \\\"Sum\\\",\\\"color\\\": \\\"msportalfx-bgcolor-f0s2\\\"}],\\\"priorPeriod\\\": true,\\\"clickAction\\\": {\\\"defaultBlade\\\": \\\"SearchBlade\\\"},\\\"horizontalBars\\\": true,\\\"showOther\\\": true,\\\"percentage\\\": false,\\\"palette\\\": \\\"blueHues\\\",\\\"yAxisOption\\\": 0,\\\"title\\\": \\\"\\\"}],\\\"currentFilter\\\": {\\\"eventTypes\\\": [1,2],\\\"typeFacets\\\": {},\\\"isPermissive\\\": false},\\\"timeContext\\\": {\\\"durationMs\\\": 75600000,\\\"endTime\\\": \\\"2018-01-31T20:30:00.000Z\\\",\\\"createdTime\\\": \\\"2018-01-31T23:54:26.280Z\\\",\\\"isInitialTime\\\": false,\\\"grain\\\": 1,\\\"useDashboardTimeRange\\\": false},\\\"jsonUri\\\": \\\"Favorite_BlankChart\\\",\\\"timeSource\\\": 0}\"}",
                Version = "ME",
                FavoriteType = ComponentFavoriteType.Shared,
                SourceType = null,
                Tags =
{
"TagSample01","TagSample02","TagSample03"
},
                Category = null,
                IsGeneratedFromTemplate = false,
            };
            ApplicationInsightsComponentFavorite result = await applicationInsightsComponent.UpdateFavoriteAsync(favoriteId, favoriteProperties);

            Console.WriteLine($"Succeeded: {result}");
        }

        // FavoriteList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteFavorite_FavoriteList()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/FavoriteDelete.json
            // this example is just showing the usage of "Favorites_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-ai-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            string favoriteId = "deadb33f-5e0d-4064-8ebb-1a4ed0313eb2";
            await applicationInsightsComponent.DeleteFavoriteAsync(favoriteId);

            Console.WriteLine($"Succeeded");
        }

        // WebTestLocationsList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetWebTestLocations_WebTestLocationsList()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/WebTestLocationsList.json
            // this example is just showing the usage of "webTestLocations_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            await foreach (ApplicationInsightsComponentWebTestLocation item in applicationInsightsComponent.GetWebTestLocationsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // webTestListByComponent
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetWebTests_WebTestListByComponent()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2022-06-15/examples/WebTestListByComponent.json
            // this example is just showing the usage of "WebTests_ListByComponent" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string componentName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, componentName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            await foreach (ApplicationInsightsWebTestResource item in applicationInsightsComponent.GetWebTestsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ApplicationInsightsWebTestData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // AnalyticsItemList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAnalyticsItems_AnalyticsItemList()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/AnalyticsItemList.json
            // this example is just showing the usage of "AnalyticsItems_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation and iterate over the result
            AnalyticsItemScopePath scopePath = AnalyticsItemScopePath.AnalyticsItems;
            await foreach (ApplicationInsightsComponentAnalyticsItem item in applicationInsightsComponent.GetAnalyticsItemsAsync(scopePath))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // AnalyticsItemGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAnalyticsItem_AnalyticsItemGet()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/AnalyticsItemGet.json
            // this example is just showing the usage of "AnalyticsItems_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            AnalyticsItemScopePath scopePath = AnalyticsItemScopePath.AnalyticsItems;
            string id = "3466c160-4a10-4df8-afdf-0007f3f6dee5";
            ApplicationInsightsComponentAnalyticsItem result = await applicationInsightsComponent.GetAnalyticsItemAsync(scopePath, id: id);

            Console.WriteLine($"Succeeded: {result}");
        }

        // AnalyticsItemPut
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task AddOrUpdateAnalyticsItem_AnalyticsItemPut()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/AnalyticsItemPut.json
            // this example is just showing the usage of "AnalyticsItems_Put" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            AnalyticsItemScopePath scopePath = AnalyticsItemScopePath.AnalyticsItems;
            ApplicationInsightsComponentAnalyticsItem itemProperties = new ApplicationInsightsComponentAnalyticsItem()
            {
                Name = "Exceptions - New in the last 24 hours",
                Content = "let newExceptionsTimeRange = 1d;\nlet timeRangeToCheckBefore = 7d;\nexceptions\n| where timestamp < ago(timeRangeToCheckBefore)\n| summarize count() by problemId\n| join kind= rightanti (\nexceptions\n| where timestamp >= ago(newExceptionsTimeRange)\n| extend stack = tostring(details[0].rawStack)\n| summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId  \n) on problemId \n| order by  count_ desc\n",
                Scope = ComponentItemScope.Shared,
                ComponentItemType = ComponentItemType.Query,
            };
            ApplicationInsightsComponentAnalyticsItem result = await applicationInsightsComponent.AddOrUpdateAnalyticsItemAsync(scopePath, itemProperties);

            Console.WriteLine($"Succeeded: {result}");
        }

        // AnalyticsItemDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteAnalyticsItem_AnalyticsItemDelete()
        {
            // Generated from example definition: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/AnalyticsItemDelete.json
            // this example is just showing the usage of "AnalyticsItems_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApplicationInsightsComponentResource created on azure
            // for more information of creating ApplicationInsightsComponentResource, please refer to the document of ApplicationInsightsComponentResource
            string subscriptionId = "subid";
            string resourceGroupName = "my-resource-group";
            string resourceName = "my-component";
            ResourceIdentifier applicationInsightsComponentResourceId = ApplicationInsightsComponentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ApplicationInsightsComponentResource applicationInsightsComponent = client.GetApplicationInsightsComponentResource(applicationInsightsComponentResourceId);

            // invoke the operation
            AnalyticsItemScopePath scopePath = AnalyticsItemScopePath.AnalyticsItems;
            string id = "3466c160-4a10-4df8-afdf-0007f3f6dee5";
            await applicationInsightsComponent.DeleteAnalyticsItemAsync(scopePath, id: id);

            Console.WriteLine($"Succeeded");
        }
    }
}
