// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AppConfiguration.Models
{
    /// <summary> The parameters for updating a configuration store. </summary>
    public partial class AppConfigurationStorePatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppConfigurationStorePatch"/>. </summary>
        public AppConfigurationStorePatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AppConfigurationStorePatch"/>. </summary>
        /// <param name="identity"> The managed identity information for the configuration store. </param>
        /// <param name="sku"> The SKU of the configuration store. </param>
        /// <param name="tags"> The ARM resource tags. </param>
        /// <param name="encryption"> The encryption settings of the configuration store. </param>
        /// <param name="disableLocalAuth"> Disables all authentication methods other than AAD authentication. </param>
        /// <param name="publicNetworkAccess"> Control permission for data plane traffic coming from public networks while private endpoint is enabled. </param>
        /// <param name="enablePurgeProtection"> Property specifying whether protection against purge is enabled for this configuration store. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppConfigurationStorePatch(ManagedServiceIdentity identity, AppConfigurationSku sku, IDictionary<string, string> tags, AppConfigurationStoreEncryptionProperties encryption, bool? disableLocalAuth, AppConfigurationPublicNetworkAccess? publicNetworkAccess, bool? enablePurgeProtection, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Identity = identity;
            Sku = sku;
            Tags = tags;
            Encryption = encryption;
            DisableLocalAuth = disableLocalAuth;
            PublicNetworkAccess = publicNetworkAccess;
            EnablePurgeProtection = enablePurgeProtection;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The managed identity information for the configuration store. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> The SKU of the configuration store. </summary>
        internal AppConfigurationSku Sku { get; set; }
        /// <summary> The SKU name of the configuration store. </summary>
        [WirePath("sku.name")]
        public string SkuName
        {
            get => Sku is null ? default : Sku.Name;
            set => Sku = new AppConfigurationSku(value);
        }

        /// <summary> The ARM resource tags. </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
        /// <summary> The encryption settings of the configuration store. </summary>
        internal AppConfigurationStoreEncryptionProperties Encryption { get; set; }
        /// <summary> Key vault properties. </summary>
        [WirePath("properties.encryption.keyVaultProperties")]
        public AppConfigurationKeyVaultProperties EncryptionKeyVaultProperties
        {
            get => Encryption is null ? default : Encryption.KeyVaultProperties;
            set
            {
                if (Encryption is null)
                    Encryption = new AppConfigurationStoreEncryptionProperties();
                Encryption.KeyVaultProperties = value;
            }
        }

        /// <summary> Disables all authentication methods other than AAD authentication. </summary>
        [WirePath("properties.disableLocalAuth")]
        public bool? DisableLocalAuth { get; set; }
        /// <summary> Control permission for data plane traffic coming from public networks while private endpoint is enabled. </summary>
        [WirePath("properties.publicNetworkAccess")]
        public AppConfigurationPublicNetworkAccess? PublicNetworkAccess { get; set; }
        /// <summary> Property specifying whether protection against purge is enabled for this configuration store. </summary>
        [WirePath("properties.enablePurgeProtection")]
        public bool? EnablePurgeProtection { get; set; }
    }
}
