// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppConfiguration.Models
{
    /// <summary> An API key used for authenticating with a configuration store endpoint. </summary>
    public partial class AppConfigurationStoreApiKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppConfigurationStoreApiKey"/>. </summary>
        internal AppConfigurationStoreApiKey()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppConfigurationStoreApiKey"/>. </summary>
        /// <param name="id"> The key ID. </param>
        /// <param name="name"> A name for the key describing its usage. </param>
        /// <param name="value"> The value of the key that is used for authentication purposes. </param>
        /// <param name="connectionString"> A connection string that can be used by supporting clients for authentication. </param>
        /// <param name="lastModifiedOn"> The last time any of the key's properties were modified. </param>
        /// <param name="isReadOnly"> Whether this key can only be used for read operations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppConfigurationStoreApiKey(string id, string name, string value, string connectionString, DateTimeOffset? lastModifiedOn, bool? isReadOnly, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            Value = value;
            ConnectionString = connectionString;
            LastModifiedOn = lastModifiedOn;
            IsReadOnly = isReadOnly;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The key ID. </summary>
        [WirePath("id")]
        public string Id { get; }
        /// <summary> A name for the key describing its usage. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> The value of the key that is used for authentication purposes. </summary>
        [WirePath("value")]
        public string Value { get; }
        /// <summary> A connection string that can be used by supporting clients for authentication. </summary>
        [WirePath("connectionString")]
        public string ConnectionString { get; }
        /// <summary> The last time any of the key's properties were modified. </summary>
        [WirePath("lastModified")]
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> Whether this key can only be used for read operations. </summary>
        [WirePath("readOnly")]
        public bool? IsReadOnly { get; }
    }
}
