// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppConfiguration.Models
{
    /// <summary> The resource type to check for name availability. </summary>
    public readonly partial struct AppConfigurationResourceType : IEquatable<AppConfigurationResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppConfigurationResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppConfigurationResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftAppConfigurationConfigurationStoresValue = "Microsoft.AppConfiguration/configurationStores";

        /// <summary> Microsoft.AppConfiguration/configurationStores. </summary>
        public static AppConfigurationResourceType MicrosoftAppConfigurationConfigurationStores { get; } = new AppConfigurationResourceType(MicrosoftAppConfigurationConfigurationStoresValue);
        /// <summary> Determines if two <see cref="AppConfigurationResourceType"/> values are the same. </summary>
        public static bool operator ==(AppConfigurationResourceType left, AppConfigurationResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppConfigurationResourceType"/> values are not the same. </summary>
        public static bool operator !=(AppConfigurationResourceType left, AppConfigurationResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppConfigurationResourceType"/>. </summary>
        public static implicit operator AppConfigurationResourceType(string value) => new AppConfigurationResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppConfigurationResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppConfigurationResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
