// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppConfiguration.Models
{
    /// <summary> The provisioning state of the replica. </summary>
    public readonly partial struct AppConfigurationReplicaProvisioningState : IEquatable<AppConfigurationReplicaProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppConfigurationReplicaProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppConfigurationReplicaProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string SucceededValue = "Succeeded";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Creating. </summary>
        public static AppConfigurationReplicaProvisioningState Creating { get; } = new AppConfigurationReplicaProvisioningState(CreatingValue);
        /// <summary> Succeeded. </summary>
        public static AppConfigurationReplicaProvisioningState Succeeded { get; } = new AppConfigurationReplicaProvisioningState(SucceededValue);
        /// <summary> Deleting. </summary>
        public static AppConfigurationReplicaProvisioningState Deleting { get; } = new AppConfigurationReplicaProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static AppConfigurationReplicaProvisioningState Failed { get; } = new AppConfigurationReplicaProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static AppConfigurationReplicaProvisioningState Canceled { get; } = new AppConfigurationReplicaProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="AppConfigurationReplicaProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AppConfigurationReplicaProvisioningState left, AppConfigurationReplicaProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppConfigurationReplicaProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AppConfigurationReplicaProvisioningState left, AppConfigurationReplicaProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppConfigurationReplicaProvisioningState"/>. </summary>
        public static implicit operator AppConfigurationReplicaProvisioningState(string value) => new AppConfigurationReplicaProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppConfigurationReplicaProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppConfigurationReplicaProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
