// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppConfiguration.Models
{
    /// <summary> The provisioning state of the configuration store. </summary>
    public readonly partial struct AppConfigurationProvisioningState : IEquatable<AppConfigurationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppConfigurationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppConfigurationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Creating. </summary>
        public static AppConfigurationProvisioningState Creating { get; } = new AppConfigurationProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static AppConfigurationProvisioningState Updating { get; } = new AppConfigurationProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static AppConfigurationProvisioningState Deleting { get; } = new AppConfigurationProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static AppConfigurationProvisioningState Succeeded { get; } = new AppConfigurationProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static AppConfigurationProvisioningState Failed { get; } = new AppConfigurationProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static AppConfigurationProvisioningState Canceled { get; } = new AppConfigurationProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="AppConfigurationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AppConfigurationProvisioningState left, AppConfigurationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppConfigurationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AppConfigurationProvisioningState left, AppConfigurationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppConfigurationProvisioningState"/>. </summary>
        public static implicit operator AppConfigurationProvisioningState(string value) => new AppConfigurationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppConfigurationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppConfigurationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
