// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.AppConfiguration.Models
{
    internal static partial class AppConfigurationCreateModeExtensions
    {
        public static string ToSerialString(this AppConfigurationCreateMode value) => value switch
        {
            AppConfigurationCreateMode.Recover => "Recover",
            AppConfigurationCreateMode.Default => "Default",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AppConfigurationCreateMode value.")
        };

        public static AppConfigurationCreateMode ToAppConfigurationCreateMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Recover")) return AppConfigurationCreateMode.Recover;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Default")) return AppConfigurationCreateMode.Default;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AppConfigurationCreateMode value.");
        }
    }
}
