// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppConfiguration.Models
{
    /// <summary> Any action that is required beyond basic workflow (approve/ reject/ disconnect). </summary>
    public readonly partial struct AppConfigurationActionsRequired : IEquatable<AppConfigurationActionsRequired>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppConfigurationActionsRequired"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppConfigurationActionsRequired(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string RecreateValue = "Recreate";

        /// <summary> None. </summary>
        public static AppConfigurationActionsRequired None { get; } = new AppConfigurationActionsRequired(NoneValue);
        /// <summary> Recreate. </summary>
        public static AppConfigurationActionsRequired Recreate { get; } = new AppConfigurationActionsRequired(RecreateValue);
        /// <summary> Determines if two <see cref="AppConfigurationActionsRequired"/> values are the same. </summary>
        public static bool operator ==(AppConfigurationActionsRequired left, AppConfigurationActionsRequired right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppConfigurationActionsRequired"/> values are not the same. </summary>
        public static bool operator !=(AppConfigurationActionsRequired left, AppConfigurationActionsRequired right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppConfigurationActionsRequired"/>. </summary>
        public static implicit operator AppConfigurationActionsRequired(string value) => new AppConfigurationActionsRequired(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppConfigurationActionsRequired other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppConfigurationActionsRequired other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
