// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppConfiguration
{
    internal class AppConfigurationStoreOperationSource : IOperationSource<AppConfigurationStoreResource>
    {
        private readonly ArmClient _client;

        internal AppConfigurationStoreOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppConfigurationStoreResource IOperationSource<AppConfigurationStoreResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppConfigurationStoreData.DeserializeAppConfigurationStoreData(document.RootElement);
            return new AppConfigurationStoreResource(_client, data);
        }

        async ValueTask<AppConfigurationStoreResource> IOperationSource<AppConfigurationStoreResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppConfigurationStoreData.DeserializeAppConfigurationStoreData(document.RootElement);
            return new AppConfigurationStoreResource(_client, data);
        }
    }
}
