// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppConfiguration
{
    internal class AppConfigurationReplicaOperationSource : IOperationSource<AppConfigurationReplicaResource>
    {
        private readonly ArmClient _client;

        internal AppConfigurationReplicaOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppConfigurationReplicaResource IOperationSource<AppConfigurationReplicaResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppConfigurationReplicaData.DeserializeAppConfigurationReplicaData(document.RootElement);
            return new AppConfigurationReplicaResource(_client, data);
        }

        async ValueTask<AppConfigurationReplicaResource> IOperationSource<AppConfigurationReplicaResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppConfigurationReplicaData.DeserializeAppConfigurationReplicaData(document.RootElement);
            return new AppConfigurationReplicaResource(_client, data);
        }
    }
}
