// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppConfiguration
{
    internal class AppConfigurationPrivateEndpointConnectionOperationSource : IOperationSource<AppConfigurationPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal AppConfigurationPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppConfigurationPrivateEndpointConnectionResource IOperationSource<AppConfigurationPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppConfigurationPrivateEndpointConnectionData.DeserializeAppConfigurationPrivateEndpointConnectionData(document.RootElement);
            return new AppConfigurationPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<AppConfigurationPrivateEndpointConnectionResource> IOperationSource<AppConfigurationPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppConfigurationPrivateEndpointConnectionData.DeserializeAppConfigurationPrivateEndpointConnectionData(document.RootElement);
            return new AppConfigurationPrivateEndpointConnectionResource(_client, data);
        }
    }
}
