// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.AppConfiguration.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableAppConfigurationArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableAppConfigurationArmClient"/> class for mocking. </summary>
        protected MockableAppConfigurationArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableAppConfigurationArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableAppConfigurationArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableAppConfigurationArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="AppConfigurationStoreResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AppConfigurationStoreResource.CreateResourceIdentifier" /> to create an <see cref="AppConfigurationStoreResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AppConfigurationStoreResource"/> object. </returns>
        public virtual AppConfigurationStoreResource GetAppConfigurationStoreResource(ResourceIdentifier id)
        {
            AppConfigurationStoreResource.ValidateResourceId(id);
            return new AppConfigurationStoreResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DeletedAppConfigurationStoreResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DeletedAppConfigurationStoreResource.CreateResourceIdentifier" /> to create a <see cref="DeletedAppConfigurationStoreResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DeletedAppConfigurationStoreResource"/> object. </returns>
        public virtual DeletedAppConfigurationStoreResource GetDeletedAppConfigurationStoreResource(ResourceIdentifier id)
        {
            DeletedAppConfigurationStoreResource.ValidateResourceId(id);
            return new DeletedAppConfigurationStoreResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AppConfigurationPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AppConfigurationPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create an <see cref="AppConfigurationPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AppConfigurationPrivateEndpointConnectionResource"/> object. </returns>
        public virtual AppConfigurationPrivateEndpointConnectionResource GetAppConfigurationPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            AppConfigurationPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new AppConfigurationPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AppConfigurationPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AppConfigurationPrivateLinkResource.CreateResourceIdentifier" /> to create an <see cref="AppConfigurationPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AppConfigurationPrivateLinkResource"/> object. </returns>
        public virtual AppConfigurationPrivateLinkResource GetAppConfigurationPrivateLinkResource(ResourceIdentifier id)
        {
            AppConfigurationPrivateLinkResource.ValidateResourceId(id);
            return new AppConfigurationPrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AppConfigurationKeyValueResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AppConfigurationKeyValueResource.CreateResourceIdentifier" /> to create an <see cref="AppConfigurationKeyValueResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AppConfigurationKeyValueResource"/> object. </returns>
        public virtual AppConfigurationKeyValueResource GetAppConfigurationKeyValueResource(ResourceIdentifier id)
        {
            AppConfigurationKeyValueResource.ValidateResourceId(id);
            return new AppConfigurationKeyValueResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AppConfigurationReplicaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AppConfigurationReplicaResource.CreateResourceIdentifier" /> to create an <see cref="AppConfigurationReplicaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AppConfigurationReplicaResource"/> object. </returns>
        public virtual AppConfigurationReplicaResource GetAppConfigurationReplicaResource(ResourceIdentifier id)
        {
            AppConfigurationReplicaResource.ValidateResourceId(id);
            return new AppConfigurationReplicaResource(Client, id);
        }
    }
}
