# Create, Retrieve and Delete a Feature Flag

The AppConfiguration service supports [Feature flags](https://docs.microsoft.com/azure/azure-app-configuration/concept-feature-management). 
Feature flags are settings that follow specific JSON schema for the `Value`, have key prefixed with the `.appconfig.featureflag/`, and the `application/vnd.microsoft.appconfig.ff+json;charset=utf-8` content type.
The `Azure.Data.AppConfiguration` library provides a strongly-typed way of managing feature flags.
This sample shows how to use the library to create, retrieve, and delete feature flags.

## Create a Feature Flag

To create a feature flag, use the `FeatureFlagConfigurationSetting` class:

```C# Snippet:Sample_CreateFeatureFlag
var featureFlagSetting = new FeatureFlagConfigurationSetting("feature_id", isEnabled: true);
```

The first parameter of the `FeatureFlagConfigurationSetting` constructor represents the `FeatureId`.
The setting's `Key` is auto-generated by prepending the `.appconfig.featureflag/` to the `FeatureId`.
In the example above the `Key` would be equal to `.appconfig.featureflag/feature_id`.
To get the prefix value programmatically, use the `FeatureFlagConfigurationSetting.KeyPrefix` static property. The correct `ContentType` is set during construction as well.

## Set a Feature Flag

The `FeatureFlagConfigurationSetting` inherits from the `ConfigurationSetting` class and can be passed to any method that accepts the `ConfigurationSetting`.

To set the feature flag, pass the instance to the `SetConfigurationSetting` method:

```C# Snippet:Sample_SetFeatureFlag
client.SetConfigurationSetting(featureFlagSetting);
```

## Retrieve a Feature Flag

You can use the `GetConfigurationSetting` method to retrieve the feature flag. The `GetConfigurationSetting` expects the setting key, so the `FeatureFlagConfigurationSetting.KeyPrefix` is used to format the full value.

```C# Snippet:Sample_GetFeatureFlag
Response<ConfigurationSetting> response = client.GetConfigurationSetting(FeatureFlagConfigurationSetting.KeyPrefix + "feature_id");
if (response.Value is FeatureFlagConfigurationSetting featureFlag)
{
    Console.WriteLine($"Feature flag {featureFlag.FeatureId} IsEnabled: {featureFlag.IsEnabled}");
}
```

## Delete a Feature Flag

Use the `DeleteConfigurationSetting` method to remove the feature flag:

```C# Snippet:Sample_DeleteFeatureFlag
client.DeleteConfigurationSetting(featureFlagSetting);
```
