// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.AppComplianceAutomation.Models;

namespace Azure.ResourceManager.AppComplianceAutomation
{
    internal partial class EvidenceRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of EvidenceRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public EvidenceRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2024-06-27";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListByReportRequestUri(string reportName, string skipToken, int? top, string select, string filter, string orderby, string offerGuid, string reportCreatorTenantId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.AppComplianceAutomation/reports/", false);
            uri.AppendPath(reportName, true);
            uri.AppendPath("/evidences", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (skipToken != null)
            {
                uri.AppendQuery("$skipToken", skipToken, true);
            }
            if (top != null)
            {
                uri.AppendQuery("$top", top.Value, true);
            }
            if (select != null)
            {
                uri.AppendQuery("$select", select, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (orderby != null)
            {
                uri.AppendQuery("$orderby", orderby, true);
            }
            if (offerGuid != null)
            {
                uri.AppendQuery("offerGuid", offerGuid, true);
            }
            if (reportCreatorTenantId != null)
            {
                uri.AppendQuery("reportCreatorTenantId", reportCreatorTenantId, true);
            }
            return uri;
        }

        internal HttpMessage CreateListByReportRequest(string reportName, string skipToken, int? top, string select, string filter, string orderby, string offerGuid, string reportCreatorTenantId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.AppComplianceAutomation/reports/", false);
            uri.AppendPath(reportName, true);
            uri.AppendPath("/evidences", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (skipToken != null)
            {
                uri.AppendQuery("$skipToken", skipToken, true);
            }
            if (top != null)
            {
                uri.AppendQuery("$top", top.Value, true);
            }
            if (select != null)
            {
                uri.AppendQuery("$select", select, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (orderby != null)
            {
                uri.AppendQuery("$orderby", orderby, true);
            }
            if (offerGuid != null)
            {
                uri.AppendQuery("offerGuid", offerGuid, true);
            }
            if (reportCreatorTenantId != null)
            {
                uri.AppendQuery("reportCreatorTenantId", reportCreatorTenantId, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Returns a paginated list of evidences for a specified report. </summary>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="skipToken"> Skip over when retrieving results. </param>
        /// <param name="top"> Number of elements to return when retrieving results. </param>
        /// <param name="select"> OData Select statement. Limits the properties on each entry to just those requested, e.g. ?$select=reportName,id. </param>
        /// <param name="filter"> The filter to apply on the operation. </param>
        /// <param name="orderby"> OData order by query option. </param>
        /// <param name="offerGuid"> The offerGuid which mapping to the reports. </param>
        /// <param name="reportCreatorTenantId"> The tenant id of the report creator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reportName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<EvidenceResourceListResult>> ListByReportAsync(string reportName, string skipToken = null, int? top = null, string select = null, string filter = null, string orderby = null, string offerGuid = null, string reportCreatorTenantId = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));

            using var message = CreateListByReportRequest(reportName, skipToken, top, select, filter, orderby, offerGuid, reportCreatorTenantId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EvidenceResourceListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = EvidenceResourceListResult.DeserializeEvidenceResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Returns a paginated list of evidences for a specified report. </summary>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="skipToken"> Skip over when retrieving results. </param>
        /// <param name="top"> Number of elements to return when retrieving results. </param>
        /// <param name="select"> OData Select statement. Limits the properties on each entry to just those requested, e.g. ?$select=reportName,id. </param>
        /// <param name="filter"> The filter to apply on the operation. </param>
        /// <param name="orderby"> OData order by query option. </param>
        /// <param name="offerGuid"> The offerGuid which mapping to the reports. </param>
        /// <param name="reportCreatorTenantId"> The tenant id of the report creator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reportName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<EvidenceResourceListResult> ListByReport(string reportName, string skipToken = null, int? top = null, string select = null, string filter = null, string orderby = null, string offerGuid = null, string reportCreatorTenantId = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));

            using var message = CreateListByReportRequest(reportName, skipToken, top, select, filter, orderby, offerGuid, reportCreatorTenantId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EvidenceResourceListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = EvidenceResourceListResult.DeserializeEvidenceResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(string reportName, string evidenceName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.AppComplianceAutomation/reports/", false);
            uri.AppendPath(reportName, true);
            uri.AppendPath("/evidences/", false);
            uri.AppendPath(evidenceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string reportName, string evidenceName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.AppComplianceAutomation/reports/", false);
            uri.AppendPath(reportName, true);
            uri.AppendPath("/evidences/", false);
            uri.AppendPath(evidenceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get the evidence metadata. </summary>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="evidenceName"> The evidence name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<AppComplianceReportEvidenceData>> GetAsync(string reportName, string evidenceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));
            Argument.AssertNotNullOrEmpty(evidenceName, nameof(evidenceName));

            using var message = CreateGetRequest(reportName, evidenceName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AppComplianceReportEvidenceData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AppComplianceReportEvidenceData.DeserializeAppComplianceReportEvidenceData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((AppComplianceReportEvidenceData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get the evidence metadata. </summary>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="evidenceName"> The evidence name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<AppComplianceReportEvidenceData> Get(string reportName, string evidenceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));
            Argument.AssertNotNullOrEmpty(evidenceName, nameof(evidenceName));

            using var message = CreateGetRequest(reportName, evidenceName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AppComplianceReportEvidenceData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AppComplianceReportEvidenceData.DeserializeAppComplianceReportEvidenceData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((AppComplianceReportEvidenceData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateOrUpdateRequestUri(string reportName, string evidenceName, AppComplianceReportEvidenceData data, string offerGuid, string reportCreatorTenantId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.AppComplianceAutomation/reports/", false);
            uri.AppendPath(reportName, true);
            uri.AppendPath("/evidences/", false);
            uri.AppendPath(evidenceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (offerGuid != null)
            {
                uri.AppendQuery("offerGuid", offerGuid, true);
            }
            if (reportCreatorTenantId != null)
            {
                uri.AppendQuery("reportCreatorTenantId", reportCreatorTenantId, true);
            }
            return uri;
        }

        internal HttpMessage CreateCreateOrUpdateRequest(string reportName, string evidenceName, AppComplianceReportEvidenceData data, string offerGuid, string reportCreatorTenantId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.AppComplianceAutomation/reports/", false);
            uri.AppendPath(reportName, true);
            uri.AppendPath("/evidences/", false);
            uri.AppendPath(evidenceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (offerGuid != null)
            {
                uri.AppendQuery("offerGuid", offerGuid, true);
            }
            if (reportCreatorTenantId != null)
            {
                uri.AppendQuery("reportCreatorTenantId", reportCreatorTenantId, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Create or Update an evidence a specified report. </summary>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="evidenceName"> The evidence name. </param>
        /// <param name="data"> Parameters for the create or update operation. </param>
        /// <param name="offerGuid"> The offerGuid which mapping to the reports. </param>
        /// <param name="reportCreatorTenantId"> The tenant id of the report creator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reportName"/>, <paramref name="evidenceName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<AppComplianceReportEvidenceData>> CreateOrUpdateAsync(string reportName, string evidenceName, AppComplianceReportEvidenceData data, string offerGuid = null, string reportCreatorTenantId = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));
            Argument.AssertNotNullOrEmpty(evidenceName, nameof(evidenceName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(reportName, evidenceName, data, offerGuid, reportCreatorTenantId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    {
                        AppComplianceReportEvidenceData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AppComplianceReportEvidenceData.DeserializeAppComplianceReportEvidenceData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Create or Update an evidence a specified report. </summary>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="evidenceName"> The evidence name. </param>
        /// <param name="data"> Parameters for the create or update operation. </param>
        /// <param name="offerGuid"> The offerGuid which mapping to the reports. </param>
        /// <param name="reportCreatorTenantId"> The tenant id of the report creator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reportName"/>, <paramref name="evidenceName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<AppComplianceReportEvidenceData> CreateOrUpdate(string reportName, string evidenceName, AppComplianceReportEvidenceData data, string offerGuid = null, string reportCreatorTenantId = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));
            Argument.AssertNotNullOrEmpty(evidenceName, nameof(evidenceName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(reportName, evidenceName, data, offerGuid, reportCreatorTenantId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    {
                        AppComplianceReportEvidenceData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AppComplianceReportEvidenceData.DeserializeAppComplianceReportEvidenceData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string reportName, string evidenceName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.AppComplianceAutomation/reports/", false);
            uri.AppendPath(reportName, true);
            uri.AppendPath("/evidences/", false);
            uri.AppendPath(evidenceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string reportName, string evidenceName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.AppComplianceAutomation/reports/", false);
            uri.AppendPath(reportName, true);
            uri.AppendPath("/evidences/", false);
            uri.AppendPath(evidenceName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Delete an existent evidence from a specified report. </summary>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="evidenceName"> The evidence name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAsync(string reportName, string evidenceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));
            Argument.AssertNotNullOrEmpty(evidenceName, nameof(evidenceName));

            using var message = CreateDeleteRequest(reportName, evidenceName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete an existent evidence from a specified report. </summary>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="evidenceName"> The evidence name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Delete(string reportName, string evidenceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));
            Argument.AssertNotNullOrEmpty(evidenceName, nameof(evidenceName));

            using var message = CreateDeleteRequest(reportName, evidenceName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDownloadRequestUri(string reportName, string evidenceName, EvidenceFileDownloadRequestContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.AppComplianceAutomation/reports/", false);
            uri.AppendPath(reportName, true);
            uri.AppendPath("/evidences/", false);
            uri.AppendPath(evidenceName, true);
            uri.AppendPath("/download", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDownloadRequest(string reportName, string evidenceName, EvidenceFileDownloadRequestContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.AppComplianceAutomation/reports/", false);
            uri.AppendPath(reportName, true);
            uri.AppendPath("/evidences/", false);
            uri.AppendPath(evidenceName, true);
            uri.AppendPath("/download", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content0 = new Utf8JsonRequestContent();
            content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
            request.Content = content0;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Download evidence file. </summary>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="evidenceName"> The evidence name. </param>
        /// <param name="content"> Parameters for the query operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reportName"/>, <paramref name="evidenceName"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<EvidenceFileDownloadResult>> DownloadAsync(string reportName, string evidenceName, EvidenceFileDownloadRequestContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));
            Argument.AssertNotNullOrEmpty(evidenceName, nameof(evidenceName));
            Argument.AssertNotNull(content, nameof(content));

            using var message = CreateDownloadRequest(reportName, evidenceName, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EvidenceFileDownloadResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = EvidenceFileDownloadResult.DeserializeEvidenceFileDownloadResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Download evidence file. </summary>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="evidenceName"> The evidence name. </param>
        /// <param name="content"> Parameters for the query operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reportName"/>, <paramref name="evidenceName"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> or <paramref name="evidenceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<EvidenceFileDownloadResult> Download(string reportName, string evidenceName, EvidenceFileDownloadRequestContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));
            Argument.AssertNotNullOrEmpty(evidenceName, nameof(evidenceName));
            Argument.AssertNotNull(content, nameof(content));

            using var message = CreateDownloadRequest(reportName, evidenceName, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EvidenceFileDownloadResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = EvidenceFileDownloadResult.DeserializeEvidenceFileDownloadResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListByReportNextPageRequestUri(string nextLink, string reportName, string skipToken, int? top, string select, string filter, string orderby, string offerGuid, string reportCreatorTenantId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListByReportNextPageRequest(string nextLink, string reportName, string skipToken, int? top, string select, string filter, string orderby, string offerGuid, string reportCreatorTenantId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Returns a paginated list of evidences for a specified report. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="skipToken"> Skip over when retrieving results. </param>
        /// <param name="top"> Number of elements to return when retrieving results. </param>
        /// <param name="select"> OData Select statement. Limits the properties on each entry to just those requested, e.g. ?$select=reportName,id. </param>
        /// <param name="filter"> The filter to apply on the operation. </param>
        /// <param name="orderby"> OData order by query option. </param>
        /// <param name="offerGuid"> The offerGuid which mapping to the reports. </param>
        /// <param name="reportCreatorTenantId"> The tenant id of the report creator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="reportName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<EvidenceResourceListResult>> ListByReportNextPageAsync(string nextLink, string reportName, string skipToken = null, int? top = null, string select = null, string filter = null, string orderby = null, string offerGuid = null, string reportCreatorTenantId = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));

            using var message = CreateListByReportNextPageRequest(nextLink, reportName, skipToken, top, select, filter, orderby, offerGuid, reportCreatorTenantId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EvidenceResourceListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = EvidenceResourceListResult.DeserializeEvidenceResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Returns a paginated list of evidences for a specified report. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="reportName"> Report Name. </param>
        /// <param name="skipToken"> Skip over when retrieving results. </param>
        /// <param name="top"> Number of elements to return when retrieving results. </param>
        /// <param name="select"> OData Select statement. Limits the properties on each entry to just those requested, e.g. ?$select=reportName,id. </param>
        /// <param name="filter"> The filter to apply on the operation. </param>
        /// <param name="orderby"> OData order by query option. </param>
        /// <param name="offerGuid"> The offerGuid which mapping to the reports. </param>
        /// <param name="reportCreatorTenantId"> The tenant id of the report creator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="reportName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="reportName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<EvidenceResourceListResult> ListByReportNextPage(string nextLink, string reportName, string skipToken = null, int? top = null, string select = null, string filter = null, string orderby = null, string offerGuid = null, string reportCreatorTenantId = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(reportName, nameof(reportName));

            using var message = CreateListByReportNextPageRequest(nextLink, reportName, skipToken, top, select, filter, orderby, offerGuid, reportCreatorTenantId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EvidenceResourceListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = EvidenceResourceListResult.DeserializeEvidenceResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
