// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> Webhook status. </summary>
    public readonly partial struct WebhookStatus : IEquatable<WebhookStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WebhookStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WebhookStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> The webhook is enabled. </summary>
        public static WebhookStatus Enabled { get; } = new WebhookStatus(EnabledValue);
        /// <summary> The webhook is disabled. </summary>
        public static WebhookStatus Disabled { get; } = new WebhookStatus(DisabledValue);
        /// <summary> Determines if two <see cref="WebhookStatus"/> values are the same. </summary>
        public static bool operator ==(WebhookStatus left, WebhookStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WebhookStatus"/> values are not the same. </summary>
        public static bool operator !=(WebhookStatus left, WebhookStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WebhookStatus"/>. </summary>
        public static implicit operator WebhookStatus(string value) => new WebhookStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WebhookStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WebhookStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
