// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> webhook deliveryStatus. </summary>
    public readonly partial struct WebhookDeliveryStatus : IEquatable<WebhookDeliveryStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WebhookDeliveryStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WebhookDeliveryStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string NotStartedValue = "NotStarted";

        /// <summary> The webhook is delivered successfully. </summary>
        public static WebhookDeliveryStatus Succeeded { get; } = new WebhookDeliveryStatus(SucceededValue);
        /// <summary> The webhook is failed to deliver. </summary>
        public static WebhookDeliveryStatus Failed { get; } = new WebhookDeliveryStatus(FailedValue);
        /// <summary> The webhook is not delivered. </summary>
        public static WebhookDeliveryStatus NotStarted { get; } = new WebhookDeliveryStatus(NotStartedValue);
        /// <summary> Determines if two <see cref="WebhookDeliveryStatus"/> values are the same. </summary>
        public static bool operator ==(WebhookDeliveryStatus left, WebhookDeliveryStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WebhookDeliveryStatus"/> values are not the same. </summary>
        public static bool operator !=(WebhookDeliveryStatus left, WebhookDeliveryStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WebhookDeliveryStatus"/>. </summary>
        public static implicit operator WebhookDeliveryStatus(string value) => new WebhookDeliveryStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WebhookDeliveryStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WebhookDeliveryStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
