// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> whether to update webhookKey. </summary>
    public readonly partial struct UpdateWebhookKey : IEquatable<UpdateWebhookKey>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UpdateWebhookKey"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UpdateWebhookKey(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "true";
        private const string FalseValue = "false";

        /// <summary> Need update the webhook key. </summary>
        public static UpdateWebhookKey True { get; } = new UpdateWebhookKey(TrueValue);
        /// <summary> No need to update the webhook key. </summary>
        public static UpdateWebhookKey False { get; } = new UpdateWebhookKey(FalseValue);
        /// <summary> Determines if two <see cref="UpdateWebhookKey"/> values are the same. </summary>
        public static bool operator ==(UpdateWebhookKey left, UpdateWebhookKey right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UpdateWebhookKey"/> values are not the same. </summary>
        public static bool operator !=(UpdateWebhookKey left, UpdateWebhookKey right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UpdateWebhookKey"/>. </summary>
        public static implicit operator UpdateWebhookKey(string value) => new UpdateWebhookKey(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UpdateWebhookKey other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UpdateWebhookKey other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
