// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    public partial class SnapshotDownloadRequestContent : IUtf8JsonSerializable, IJsonModel<SnapshotDownloadRequestContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SnapshotDownloadRequestContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SnapshotDownloadRequestContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SnapshotDownloadRequestContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SnapshotDownloadRequestContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ReportCreatorTenantId))
            {
                writer.WritePropertyName("reportCreatorTenantId"u8);
                writer.WriteStringValue(ReportCreatorTenantId.Value);
            }
            writer.WritePropertyName("downloadType"u8);
            writer.WriteStringValue(DownloadType.ToString());
            if (Optional.IsDefined(OfferGuid))
            {
                writer.WritePropertyName("offerGuid"u8);
                writer.WriteStringValue(OfferGuid);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SnapshotDownloadRequestContent IJsonModel<SnapshotDownloadRequestContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SnapshotDownloadRequestContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SnapshotDownloadRequestContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSnapshotDownloadRequestContent(document.RootElement, options);
        }

        internal static SnapshotDownloadRequestContent DeserializeSnapshotDownloadRequestContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Guid? reportCreatorTenantId = default;
            AppComplianceDownloadType downloadType = default;
            string offerGuid = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("reportCreatorTenantId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    reportCreatorTenantId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("downloadType"u8))
                {
                    downloadType = new AppComplianceDownloadType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("offerGuid"u8))
                {
                    offerGuid = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SnapshotDownloadRequestContent(reportCreatorTenantId, downloadType, offerGuid, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SnapshotDownloadRequestContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SnapshotDownloadRequestContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SnapshotDownloadRequestContent)} does not support writing '{options.Format}' format.");
            }
        }

        SnapshotDownloadRequestContent IPersistableModel<SnapshotDownloadRequestContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SnapshotDownloadRequestContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSnapshotDownloadRequestContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SnapshotDownloadRequestContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SnapshotDownloadRequestContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
