// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppComplianceAutomation.Models
{
    /// <summary> whether to send notification under any event. </summary>
    public readonly partial struct SendAllEvent : IEquatable<SendAllEvent>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SendAllEvent"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SendAllEvent(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "true";
        private const string FalseValue = "false";

        /// <summary> Need send notification under any event. </summary>
        public static SendAllEvent True { get; } = new SendAllEvent(TrueValue);
        /// <summary> No need to send notification under any event. </summary>
        public static SendAllEvent False { get; } = new SendAllEvent(FalseValue);
        /// <summary> Determines if two <see cref="SendAllEvent"/> values are the same. </summary>
        public static bool operator ==(SendAllEvent left, SendAllEvent right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SendAllEvent"/> values are not the same. </summary>
        public static bool operator !=(SendAllEvent left, SendAllEvent right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SendAllEvent"/>. </summary>
        public static implicit operator SendAllEvent(string value) => new SendAllEvent(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SendAllEvent other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SendAllEvent other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
